/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep.elections;

import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.config.IntConfigParam;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.rep.QuorumPolicy;
import com.sleepycat.je.rep.elections.Acceptor;
import com.sleepycat.je.rep.elections.Learner;
import com.sleepycat.je.rep.elections.MasterValue;
import com.sleepycat.je.rep.elections.Proposer;
import com.sleepycat.je.rep.elections.Protocol;
import com.sleepycat.je.rep.elections.RankingProposer;
import com.sleepycat.je.rep.elections.TimebasedProposalGenerator;
import com.sleepycat.je.rep.elections.Utils;
import com.sleepycat.je.rep.impl.RepGroupImpl;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import com.sleepycat.je.rep.impl.TextProtocol;
import com.sleepycat.je.rep.impl.node.NameIdPair;
import com.sleepycat.je.rep.impl.node.RepNode;
import com.sleepycat.je.rep.utilint.ReplicationFormatter;
import com.sleepycat.je.rep.utilint.ServiceDispatcher;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.StatGroup;
import com.sleepycat.je.utilint.StoppableThread;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Elections
extends StoppableThread {
    private RepGroupImpl repGroup;
    private final NameIdPair nameIdPair;
    private final RepNode repNode;
    private Proposer proposer;
    private Acceptor acceptor;
    private Learner learner;
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private final Acceptor.SuggestionGenerator suggestionGenerator;
    private final Learner.Listener listener;
    private final Protocol protocol;
    private volatile ElectionThread electionThread = null;
    private ElectionListener electionListener = null;
    private int nElections = 0;
    private final Logger logger;
    private final Formatter formatter;

    public Elections(RepNode repNode, Learner.Listener listener, Acceptor.SuggestionGenerator suggestionGenerator) {
        super(repNode.getRepImpl());
        this.repNode = repNode;
        this.nameIdPair = repNode.getNameIdPair();
        this.logger = this.envImpl != null ? LoggerUtils.getLogger(this.getClass()) : LoggerUtils.getLoggerFormatterNeeded(this.getClass());
        this.formatter = new ReplicationFormatter(this.nameIdPair);
        String groupName = this.envImpl != null ? this.envImpl.getConfigManager().get(RepParams.GROUP_NAME) : "TEST_GROUP";
        this.protocol = new Protocol(TimebasedProposalGenerator.getParser(), MasterValue.getParser(), groupName, this.nameIdPair, repNode.getRepImpl());
        this.suggestionGenerator = suggestionGenerator;
        this.listener = listener;
    }

    public ExecutorService getThreadPool() {
        return this.pool;
    }

    public ServiceDispatcher getServiceDispatcher() {
        return this.repNode.getServiceDispatcher();
    }

    public RepNode getRepNode() {
        return this.repNode;
    }

    public RepImpl getRepImpl() {
        return this.repNode.getRepImpl();
    }

    public void startLearner() throws IOException {
        this.learner = new Learner(this.protocol, this.repNode);
        this.learner.start();
        this.learner.addListener(this.listener);
        this.electionListener = new ElectionListener();
        this.learner.addListener(this.electionListener);
    }

    public void participate() throws IOException {
        this.proposer = new RankingProposer(this, this.nameIdPair);
        this.acceptor = new Acceptor(this.protocol, this.repNode, this.suggestionGenerator);
        this.acceptor.start();
    }

    public Acceptor getAcceptor() {
        return this.acceptor;
    }

    public Set<InetSocketAddress> getAcceptorSockets() {
        if (this.repGroup == null) {
            throw EnvironmentFailureException.unexpectedState("No rep group was configured");
        }
        return this.repGroup.getAcceptorSockets();
    }

    Protocol getProtocol() {
        return this.protocol;
    }

    public Learner getLearner() {
        return this.learner;
    }

    public int getElectionCount() {
        return this.nElections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initiateElection(RepGroupImpl newGroup, QuorumPolicy quorumPolicy, int maxRetries) throws InterruptedException {
        this.updateRepGroup(newGroup);
        long startTime = System.currentTimeMillis();
        ++this.nElections;
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election initiated; election #" + this.nElections);
        if (this.electionThread != null) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election in progress. Waiting....");
            this.electionThread.join();
            Exception exception = this.electionThread.getSavedShutdownException();
            if (exception != null) {
                throw new EnvironmentFailureException(this.envImpl, EnvironmentFailureReason.UNEXPECTED_EXCEPTION, (Throwable)exception);
            }
        }
        CountDownLatch countDownLatch = null;
        ElectionListener electionListener = this.electionListener;
        synchronized (electionListener) {
            countDownLatch = this.electionListener.setLatch();
        }
        RetryPredicate retryPredicate = new RetryPredicate(this.repNode, maxRetries, countDownLatch);
        this.electionThread = new ElectionThread(quorumPolicy, retryPredicate);
        this.electionThread.start();
        try {
            countDownLatch.await();
            if (retryPredicate.pendingRetries <= 0) {
                LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Retry count exhausted: " + retryPredicate.maxRetries);
            }
        }
        catch (InterruptedException e) {
            LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.WARNING, "Election initiation interrupted");
            this.shutdown();
            throw e;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Election finished. Elapsed time: " + (System.currentTimeMillis() - startTime) + "ms");
    }

    public synchronized void initiateElection(RepGroupImpl newGroup, QuorumPolicy quorumPolicy) throws InterruptedException {
        this.initiateElection(newGroup, quorumPolicy, Integer.MAX_VALUE);
    }

    public void updateRepGroup(RepGroupImpl newRepGroup) {
        this.repGroup = newRepGroup;
        this.protocol.updateNodeIds(newRepGroup.getAllMemberIds());
    }

    public synchronized boolean electionInProgress() {
        return this.electionThread != null && this.electionThread.isAlive();
    }

    public synchronized StatGroup getStats() {
        if (this.electionInProgress()) {
            throw EnvironmentFailureException.unexpectedState("Election in progress");
        }
        return this.electionThread.getStats();
    }

    public synchronized void waitForElection() throws InterruptedException {
        assert (this.electionThread != null);
        this.electionThread.join();
    }

    public void shutdownAcceptorsLearners(Set<InetSocketAddress> acceptorSockets, Set<InetSocketAddress> learnerSockets) throws InterruptedException {
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Elections being shutdown");
        List<Future<TextProtocol.MessageExchange>> futures = Utils.broadcastMessage(acceptorSockets, "Acceptor", new Protocol.Shutdown(this.protocol), this.pool);
        Utils.checkFutures(futures, this.logger, this.envImpl, this.formatter);
        futures = Utils.broadcastMessage(learnerSockets, "Learner", new Protocol.Shutdown(this.protocol), this.pool);
        Utils.checkFutures(futures, this.logger, this.envImpl, this.formatter);
        if (this.learner != null) {
            this.learner.join();
        }
        if (this.acceptor != null) {
            this.acceptor.join();
        }
    }

    public void shutdown() throws InterruptedException {
        if (this.shutdownDone()) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Elections shutdown initiated");
        if (this.acceptor != null) {
            this.acceptor.shutdown();
        }
        if (this.learner != null) {
            this.learner.shutdown();
            this.learner.join();
        }
        if (this.acceptor != null) {
            this.acceptor.join();
        }
        if (this.electionThread != null) {
            if (this.electionListener.getElectionLatch() != null) {
                this.electionListener.getElectionLatch().countDown();
            }
            this.electionThread.interrupt();
            this.electionThread.join();
        }
        if (this.proposer != null) {
            this.proposer.shutDown();
        }
        this.pool.shutdown();
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, "Elections shutdown completed");
    }

    @Override
    protected Logger getLogger() {
        return this.logger;
    }

    public void asyncInformMonitors(Proposer.Proposal proposal, Protocol.Value value) {
        Set<InetSocketAddress> monitorSockets = this.repGroup.getMonitorSockets();
        if (monitorSockets.size() == 0) {
            return;
        }
        LoggerUtils.logMsg(this.logger, this.envImpl, this.formatter, Level.INFO, String.format("Propagating election results to %d monitors\n", monitorSockets.size()));
        this.pool.execute(new InformMonitors(monitorSockets, new Proposer.WinningProposal(proposal, value, null)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InformMonitors
    implements Runnable {
        final Set<InetSocketAddress> monitors;
        final Proposer.WinningProposal winningProposal;

        InformMonitors(Set<InetSocketAddress> monitors, Proposer.WinningProposal winningProposal) {
            this.monitors = monitors;
            this.winningProposal = winningProposal;
        }

        @Override
        public void run() {
            Learner.informLearners(this.monitors, this.winningProposal, Elections.this.protocol, Elections.this.pool, Elections.this.logger, Elections.this.repNode.getRepImpl(), null);
        }
    }

    private class ElectionThread
    extends StoppableThread {
        private final QuorumPolicy quorumPolicy;
        Proposer.WinningProposal winningProposal;
        Proposer.MaxRetriesException maxRetriesException;
        private final RetryPredicate retryPredicate;

        private ElectionThread(QuorumPolicy quorumPolicy, RetryPredicate retryPredicate) {
            super(Elections.this.repNode.getRepImpl());
            this.quorumPolicy = quorumPolicy;
            this.retryPredicate = retryPredicate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            try {
                try {
                    LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Started election thread " + new Date());
                    this.winningProposal = Elections.this.proposer.issueProposal(this.quorumPolicy, this.retryPredicate);
                    Learner.informLearners(Elections.this.repGroup.getLearnerSockets(), this.winningProposal, Elections.this.protocol, Elections.this.pool, Elections.this.logger, Elections.this.repNode.getRepImpl(), null);
                }
                catch (Proposer.MaxRetriesException mre) {
                    this.maxRetriesException = mre;
                    LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Exiting election after " + this.retryPredicate.retries() + " retries");
                    Object var3_2 = null;
                    this.cleanup();
                    Elections.this.repNode.getMasterStatus().getGroupMasterNameId();
                    LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Election thread exited. Group master: " + Elections.this.repNode.getMasterStatus().getGroupMasterNameId());
                    return;
                }
                catch (InterruptedException e) {
                    LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Election thread interrupted");
                    Object var3_3 = null;
                    this.cleanup();
                    Elections.this.repNode.getMasterStatus().getGroupMasterNameId();
                    LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Election thread exited. Group master: " + Elections.this.repNode.getMasterStatus().getGroupMasterNameId());
                    return;
                }
                catch (Exception e) {
                    this.saveShutdownException(e);
                    Object var3_4 = null;
                    this.cleanup();
                    Elections.this.repNode.getMasterStatus().getGroupMasterNameId();
                    LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Election thread exited. Group master: " + Elections.this.repNode.getMasterStatus().getGroupMasterNameId());
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.cleanup();
                Elections.this.repNode.getMasterStatus().getGroupMasterNameId();
                LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Election thread exited. Group master: " + Elections.this.repNode.getMasterStatus().getGroupMasterNameId());
                throw throwable;
            }
            this.cleanup();
            Elections.this.repNode.getMasterStatus().getGroupMasterNameId();
            LoggerUtils.logMsg(Elections.this.logger, this.envImpl, Elections.this.formatter, Level.INFO, "Election thread exited. Group master: " + Elections.this.repNode.getMasterStatus().getGroupMasterNameId());
        }

        StatGroup getStats() {
            return this.winningProposal != null ? this.winningProposal.proposerStats : this.maxRetriesException.proposerStats;
        }

        protected Logger getLogger() {
            return Elections.this.logger;
        }
    }

    static class RetryPredicate
    implements Proposer.RetryPredicate {
        private final RepNode repNode;
        private final int maxRetries;
        private int pendingRetries;
        private final CountDownLatch electionLatch;
        private final int primaryRetries;
        private static final int BACKOFF_SLEEP_MIN = 1;
        private static final int BACKOFF_SLEEP_MAX = 64;
        private int backoffSleepInterval = 1;

        RetryPredicate(RepNode repNode, int maxRetries, CountDownLatch electionLatch) {
            this.repNode = repNode;
            this.maxRetries = maxRetries;
            this.pendingRetries = maxRetries;
            this.electionLatch = electionLatch;
            RepImpl repImpl = repNode.getRepImpl();
            IntConfigParam retriesParam = RepParams.ELECTIONS_PRIMARY_RETRIES;
            this.primaryRetries = repImpl != null ? repImpl.getConfigManager().getInt(retriesParam) : Integer.parseInt(retriesParam.getDefault());
        }

        private int backoffWaitTime() {
            this.backoffSleepInterval = Math.min(64, this.backoffSleepInterval * 2);
            return this.backoffSleepInterval * 1000;
        }

        public boolean retry() throws InterruptedException {
            if (this.maxRetries - this.pendingRetries >= this.primaryRetries && this.repNode != null && this.repNode.tryActivatePrimary()) {
                this.pendingRetries = this.maxRetries;
                return true;
            }
            if (this.pendingRetries-- <= 0) {
                this.electionLatch.countDown();
                return false;
            }
            this.electionLatch.await(this.backoffWaitTime(), TimeUnit.MILLISECONDS);
            return this.electionLatch.getCount() != 0L;
        }

        public int retries() {
            return this.maxRetries - this.pendingRetries;
        }
    }

    static class ElectionListener
    implements Learner.Listener {
        private CountDownLatch electionLatch = null;

        ElectionListener() {
        }

        public synchronized CountDownLatch setLatch() {
            this.electionLatch = new CountDownLatch(1);
            return this.electionLatch;
        }

        public CountDownLatch getElectionLatch() {
            return this.electionLatch;
        }

        public synchronized void notify(Proposer.Proposal proposal, Protocol.Value value) {
            if (this.electionLatch != null) {
                this.electionLatch.countDown();
            }
        }
    }
}

