/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.rep.impl.node.FeederManager;
import com.sleepycat.je.rep.impl.node.FeederManagerStatDefinition;
import com.sleepycat.je.rep.impl.node.ReplayStatDefinition;
import com.sleepycat.je.rep.impl.node.Replica;
import com.sleepycat.je.rep.impl.node.ReplicaStatDefinition;
import com.sleepycat.je.rep.utilint.BinaryProtocolStatDefinition;
import com.sleepycat.je.utilint.LongStat;
import com.sleepycat.je.utilint.StatGroup;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicatedEnvironmentStats {
    private final StatGroup feederManagerStats;
    private final StatGroup replayStats;
    private final StatGroup trackerStats;
    private final StatGroup protocolStats;
    private final Map<String, String> tipsMap = new HashMap<String, String>();

    ReplicatedEnvironmentStats(FeederManager feederManager, Replica replica, StatsConfig config) {
        this.feederManagerStats = feederManager.getFeederManagerStats(config);
        this.replayStats = replica.getReplayStats(config);
        this.trackerStats = replica.getTrackerStats(config);
        this.protocolStats = feederManager.getProtocolStats(config);
        this.protocolStats.addAll(replica.getProtocolStats(config));
        this.addAvgProtocolStats();
    }

    private void addAvgProtocolStats() {
        LongStat avgReadNanos = new LongStat(this.protocolStats, BinaryProtocolStatDefinition.AVG_READ_NANOS);
        long value = this.getNProtocolMessagesRead() != 0L ? this.getProtocolReadNanos() / this.getNProtocolMessagesRead() : 0L;
        avgReadNanos.set(value);
        LongStat avgWriteNanos = new LongStat(this.protocolStats, BinaryProtocolStatDefinition.AVG_WRITE_NANOS);
        value = this.getNProtocolMessagesWritten() != 0L ? this.getProtocolWriteNanos() / this.getNProtocolMessagesWritten() : 0L;
        avgWriteNanos.set(value);
    }

    public int getNFeedersCreated() {
        return this.feederManagerStats.getInt(FeederManagerStatDefinition.N_FEEDERS_CREATED);
    }

    public int getNFeedersShutdown() {
        return this.feederManagerStats.getInt(FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN);
    }

    public long getNReplayCommits() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMITS);
    }

    public long getNReplayCommitAcks() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_ACKS);
    }

    public long getNReplayCommitSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_SYNCS);
    }

    public long getNReplayCommitNoSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_NO_SYNCS);
    }

    public long getNReplayCommitWriteNoSyncs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS);
    }

    public long getNReplayAborts() {
        return this.replayStats.getLong(ReplayStatDefinition.N_ABORTS);
    }

    public long getNReplayNameLNs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_NAME_LNS);
    }

    public long getNReplayLNs() {
        return this.replayStats.getLong(ReplayStatDefinition.N_LNS);
    }

    public long getReplayElapsedTxnTime() {
        return this.replayStats.getLong(ReplayStatDefinition.N_ELAPSED_TXN_TIME);
    }

    public long getReplayMinCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayMaxCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS);
    }

    public long getReplayTotalCommitProcessingNanos() {
        return this.replayStats.getLong(ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS);
    }

    public long getNProtocolBytesRead() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_BYTES_READ);
    }

    public long getNProtocolMessagesRead() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_READ);
    }

    public long getNProtocolBytesWritten() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_BYTES_WRITTEN);
    }

    public long getNProtocolMessagesWritten() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN);
    }

    public long getProtocolReadNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_READ_NANOS);
    }

    public long getProtocolWriteNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.N_WRITE_NANOS);
    }

    public long getProtocolAvgReadNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.AVG_READ_NANOS);
    }

    public long getProtocolAvgWriteNanos() {
        return this.protocolStats.getLong(BinaryProtocolStatDefinition.AVG_WRITE_NANOS);
    }

    public long getTrackerLagConsistencyWaits() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAITS);
    }

    public long getTrackerLagConsistencyWaitMs() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAIT_MS);
    }

    public long getTrackerVLSNConsistencyWaits() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAITS);
    }

    public long getTrackerVLSNConsistencyWaitMs() {
        return this.trackerStats.getLong(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAIT_MS);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.feederManagerStats.toString());
        sb.append(this.protocolStats.toString());
        sb.append(this.replayStats.toString());
        sb.append(this.trackerStats.toString());
        return sb.toString();
    }

    public String toStringVerbose() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.feederManagerStats.toStringVerbose());
        sb.append(this.protocolStats.toStringVerbose());
        sb.append(this.replayStats.toStringVerbose());
        sb.append(this.trackerStats.toStringVerbose());
        return sb.toString();
    }

    public Map<String, String> getTips() {
        this.tipsMap.put(this.feederManagerStats.getName(), this.feederManagerStats.getDescription());
        this.tipsMap.put(FeederManagerStatDefinition.N_FEEDERS_CREATED.getName(), FeederManagerStatDefinition.N_FEEDERS_CREATED.getDescription());
        this.tipsMap.put(FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN.getName(), FeederManagerStatDefinition.N_FEEDERS_SHUTDOWN.getDescription());
        this.tipsMap.put(this.protocolStats.getName(), this.protocolStats.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.AVG_READ_NANOS.getName(), BinaryProtocolStatDefinition.AVG_READ_NANOS.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.AVG_WRITE_NANOS.getName(), BinaryProtocolStatDefinition.AVG_WRITE_NANOS.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.N_BYTES_READ.getName(), BinaryProtocolStatDefinition.N_BYTES_READ.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.N_BYTES_WRITTEN.getName(), BinaryProtocolStatDefinition.N_BYTES_WRITTEN.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.N_MESSAGES_READ.getName(), BinaryProtocolStatDefinition.N_MESSAGES_READ.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN.getName(), BinaryProtocolStatDefinition.N_MESSAGES_WRITTEN.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.N_READ_NANOS.getName(), BinaryProtocolStatDefinition.N_READ_NANOS.getDescription());
        this.tipsMap.put(BinaryProtocolStatDefinition.N_WRITE_NANOS.getName(), BinaryProtocolStatDefinition.N_WRITE_NANOS.getDescription());
        this.tipsMap.put(this.replayStats.getName(), this.replayStats.getDescription());
        this.tipsMap.put(ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS.getName(), ReplayStatDefinition.MAX_COMMIT_PROCESSING_NANOS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS.getName(), ReplayStatDefinition.MIN_COMMIT_PROCESSING_NANOS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_ABORTS.getName(), ReplayStatDefinition.N_ABORTS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_COMMITS.getName(), ReplayStatDefinition.N_COMMITS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_COMMIT_ACKS.getName(), ReplayStatDefinition.N_COMMIT_ACKS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_COMMIT_NO_SYNCS.getName(), ReplayStatDefinition.N_COMMIT_NO_SYNCS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_COMMIT_SYNCS.getName(), ReplayStatDefinition.N_COMMIT_SYNCS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS.getName(), ReplayStatDefinition.N_COMMIT_WRITE_NO_SYNCS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_ELAPSED_TXN_TIME.getName(), ReplayStatDefinition.N_ELAPSED_TXN_TIME.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_LNS.getName(), ReplayStatDefinition.N_LNS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.N_NAME_LNS.getName(), ReplayStatDefinition.N_NAME_LNS.getDescription());
        this.tipsMap.put(ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS.getName(), ReplayStatDefinition.TOTAL_COMMIT_PROCESSING_NANOS.getDescription());
        this.tipsMap.put(this.trackerStats.getName(), this.trackerStats.getDescription());
        this.tipsMap.put(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAITS.getName(), ReplicaStatDefinition.N_LAG_CONSISTENCY_WAITS.getDescription());
        this.tipsMap.put(ReplicaStatDefinition.N_LAG_CONSISTENCY_WAIT_MS.getName(), ReplicaStatDefinition.N_LAG_CONSISTENCY_WAIT_MS.getDescription());
        this.tipsMap.put(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAITS.getName(), ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAITS.getDescription());
        this.tipsMap.put(ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAIT_MS.getName(), ReplicaStatDefinition.N_VLSN_CONSISTENCY_WAIT_MS.getDescription());
        return this.tipsMap;
    }
}

