/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.CacheMode;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentFailureException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentFailureReason;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.ChecksumException;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.LoggerUtils;
import com.sleepycat.je.utilint.VLSN;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FileProcessor
extends DaemonThread {
    private static final int PROCESS_PENDING_EVERY_N_LNS = 100;
    private static final boolean PROHIBIT_DELTAS_WHEN_FETCHING = false;
    private static final boolean DEBUG_TRACING = false;
    private EnvironmentImpl env;
    private Cleaner cleaner;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private int fileLogVersion;
    private int nINsObsoleteThisRun = 0;
    private int nINsCleanedThisRun = 0;
    private int nINsDeadThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nLNsObsoleteThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nLNsMarkedThisRun = 0;
    private int nLNQueueHitsThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;

    FileProcessor(String name, EnvironmentImpl env, Cleaner cleaner, UtilizationProfile profile, FileSelector fileSelector) {
        super(0L, name, env);
        this.env = env;
        this.cleaner = cleaner;
        this.fileSelector = fileSelector;
        this.profile = profile;
    }

    public void clearEnv() {
        this.env = null;
        this.cleaner = null;
        this.fileSelector = null;
        this.profile = null;
    }

    @Override
    protected long nDeadlockRetries() {
        return this.cleaner.nDeadlockRetries;
    }

    @Override
    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        if (this.env.isClosed()) {
            return 0;
        }
        int nOriginalLogFiles = this.profile.getNumberOfFiles();
        int nFilesCleaned = 0;
        do {
            String traceMsg;
            Object var17_17;
            if (nFilesCleaned >= nOriginalLogFiles) {
                return nFilesCleaned;
            }
            if (invokedFromDaemon) {
                if (this.isPaused()) return nFilesCleaned;
            }
            if (this.env.isClosing()) {
                return nFilesCleaned;
            }
            this.cleaner.processPending();
            boolean needLowUtilizationSet = this.cleaner.clusterResident || this.cleaner.clusterAll;
            Long fileNum = this.fileSelector.selectFileForCleaning(this.profile, forceCleaning, needLowUtilizationSet, this.cleaner.maxBatchFiles);
            this.cleaner.updateReadOnlyFileCollections();
            if (fileNum == null) {
                return nFilesCleaned;
            }
            this.resetPerRunCounters();
            boolean finished = false;
            boolean fileDeleted = false;
            long fileNumValue = fileNum;
            this.cleaner.nCleanerRuns.increment();
            long runId = this.cleaner.nCleanerRuns.get();
            MemoryBudget budget = this.env.getMemoryBudget();
            try {
                try {
                    String traceMsg2 = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " begins backlog=" + this.fileSelector.getBacklog();
                    LoggerUtils.logMsg(this.logger, this.env, Level.FINE, traceMsg2);
                    if (this.processFile(fileNum)) {
                        ++nFilesCleaned;
                        this.accumulatePerRunCounters();
                        finished = true;
                    }
                }
                catch (FileNotFoundException e) {
                    fileDeleted = true;
                    this.profile.removeFile(fileNum, null);
                    this.fileSelector.removeAllFileReferences(fileNum, budget);
                    var17_17 = null;
                    if (!finished && !fileDeleted) {
                        this.fileSelector.putBackFileForCleaning(fileNum);
                    }
                    traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                    LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, traceMsg);
                    continue;
                }
                catch (IOException e) {
                    LoggerUtils.traceAndLogException(this.env, "Cleaner", "doClean", "", e);
                    throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_INTEGRITY, (Throwable)e);
                }
                catch (DatabaseException e) {
                    LoggerUtils.traceAndLogException(this.env, "Cleaner", "doClean", "", e);
                    throw e;
                }
                var17_17 = null;
                if (!finished && !fileDeleted) {
                    this.fileSelector.putBackFileForCleaning(fileNum);
                }
                traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
            }
            catch (Throwable throwable) {
                var17_17 = null;
                if (!finished && !fileDeleted) {
                    this.fileSelector.putBackFileForCleaning(fileNum);
                }
                traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " fileDeleted=" + fileDeleted + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, traceMsg);
                throw throwable;
            }
            LoggerUtils.traceAndLog(this.logger, this.env, Level.FINE, traceMsg);
        } while (cleanMultipleFiles);
        return nFilesCleaned;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processFile(Long fileNum) throws DatabaseException, IOException {
        PackedOffsets obsoleteOffsets = new PackedOffsets();
        TrackedFileSummary tfs = this.profile.getObsoleteDetail(fileNum, obsoleteOffsets, true);
        PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
        long nextObsolete = -1L;
        int readBufferSize = this.cleaner.readBufferSize;
        int lookAheadCacheSize = this.cleaner.lookAheadCacheSize;
        int adjustMem = 2 * readBufferSize + obsoleteOffsets.getLogSize() + lookAheadCacheSize;
        MemoryBudget budget = this.env.getMemoryBudget();
        budget.updateAdminMemoryUsage(adjustMem);
        this.env.criticalEviction(true);
        LookAheadCache lookAheadCache = new LookAheadCache(lookAheadCacheSize);
        HashSet<DatabaseId> checkPendingDbSet = new HashSet<DatabaseId>();
        HashMap<DatabaseId, DatabaseImpl> dbCache = new HashMap<DatabaseId, DatabaseImpl>();
        DbTree dbMapTree = this.env.getDbTree();
        HashSet<DatabaseId> databases = new HashSet<DatabaseId>();
        VLSN lastVLSN = VLSN.NULL_VLSN;
        try {
            try {
                CleanerFileReader reader = new CleanerFileReader(this.env, readBufferSize, DbLsn.makeLsn((long)fileNum, 0), fileNum);
                reader.setAlwaysValidateChecksum(true);
                TreeLocation location = new TreeLocation();
                int nProcessedLNs = 0;
                while (reader.readNextEntryAllowExceptions()) {
                    VLSN vlsn;
                    this.cleaner.nEntriesRead.increment();
                    long logLsn = reader.getLastLsn();
                    long fileOffset = DbLsn.getFileOffset(logLsn);
                    boolean isLN = reader.isLN();
                    boolean isIN = reader.isIN();
                    boolean isRoot = reader.isRoot();
                    boolean isObsolete = false;
                    DatabaseId dbId = reader.getDatabaseId();
                    if (dbId != null) {
                        databases.add(dbId);
                    }
                    if ((vlsn = reader.getVLSN()) != null) {
                        assert (vlsn.compareTo(lastVLSN) > 0) : "vlsns out of order, last=" + lastVLSN + " current=" + vlsn;
                        lastVLSN = vlsn;
                    }
                    if (reader.isFileHeader()) {
                        this.fileLogVersion = reader.getFileHeader().getLogVersion();
                    }
                    if (this.env.isClosing()) {
                        boolean bl = false;
                        Object var35_34 = null;
                        budget.updateAdminMemoryUsage(0 - adjustMem);
                        dbMapTree.releaseDbs(dbCache);
                        if (tfs != null) {
                            tfs.setAllowFlush(true);
                        }
                        return bl;
                    }
                    int nReads = reader.getAndResetNReads();
                    if (nReads > 0) {
                        this.env.updateBackgroundReads(nReads);
                    }
                    this.env.sleepAfterBackgroundIO();
                    while (nextObsolete < fileOffset && obsoleteIter.hasNext()) {
                        nextObsolete = obsoleteIter.next();
                    }
                    if (nextObsolete == fileOffset) {
                        isObsolete = true;
                    }
                    if (!(isObsolete || isLN || isIN || isRoot)) {
                        isObsolete = true;
                    }
                    if (!isObsolete && isLN && reader.getLN().isDeleted() && this.fileLogVersion > 2) {
                        isObsolete = true;
                    }
                    if (!isObsolete && tfs != null && tfs.containsObsoleteOffset(fileOffset)) {
                        isObsolete = true;
                    }
                    if (isObsolete) {
                        if (isLN) {
                            ++this.nLNsObsoleteThisRun;
                        } else if (isIN) {
                            ++this.nINsObsoleteThisRun;
                        }
                        if (dbId == null) continue;
                        checkPendingDbSet.add(dbId);
                        continue;
                    }
                    this.env.criticalEviction(true);
                    if (isLN) {
                        LN targetLN = reader.getLN();
                        byte[] key = reader.getKey();
                        byte[] dupKey = reader.getDupTreeKey();
                        lookAheadCache.add(DbLsn.getFileOffset(logLsn), new LNInfo(targetLN, dbId, key, dupKey));
                        if (lookAheadCache.isFull()) {
                            this.processLN(fileNum, location, lookAheadCache, dbCache);
                        }
                        if (++nProcessedLNs % 100 != 0) continue;
                        this.cleaner.processPending();
                        continue;
                    }
                    if (isIN) {
                        IN targetIN = reader.getIN();
                        DatabaseImpl db = dbMapTree.getDb(dbId, this.cleaner.lockTimeout, dbCache);
                        targetIN.setDatabase(db);
                        this.processIN(targetIN, db, logLsn);
                        continue;
                    }
                    if (isRoot) {
                        this.env.rewriteMapTreeRoot(logLsn);
                        continue;
                    }
                    assert (false);
                }
                while (!lookAheadCache.isEmpty()) {
                    this.env.criticalEviction(true);
                    this.processLN(fileNum, location, lookAheadCache, dbCache);
                    this.env.sleepAfterBackgroundIO();
                }
                for (DatabaseId pendingDbId : checkPendingDbSet) {
                    DatabaseImpl db = dbMapTree.getDb(pendingDbId, this.cleaner.lockTimeout, dbCache);
                    this.cleaner.addPendingDB(db);
                }
                this.nEntriesReadThisRun = reader.getNumRead();
                this.nRepeatIteratorReadsThisRun = reader.getNRepeatIteratorReads();
            }
            catch (ChecksumException e) {
                throw new EnvironmentFailureException(this.env, EnvironmentFailureReason.LOG_CHECKSUM, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var35_36 = null;
            budget.updateAdminMemoryUsage(0 - adjustMem);
            dbMapTree.releaseDbs(dbCache);
            if (tfs != null) {
                tfs.setAllowFlush(true);
            }
            throw throwable;
        }
        Object var35_35 = null;
        budget.updateAdminMemoryUsage(0 - adjustMem);
        dbMapTree.releaseDbs(dbCache);
        if (tfs != null) {
            tfs.setAllowFlush(true);
        }
        this.fileSelector.addCleanedFile(fileNum, databases, lastVLSN, budget);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processLN(Long fileNum, TreeLocation location, LookAheadCache lookAheadCache, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        IN parentDIN;
        IN bin;
        boolean completed;
        boolean obsolete;
        boolean processedHere;
        long logLsn;
        LN ln;
        block25: {
            block24: {
                block23: {
                    block21: {
                        block22: {
                            ++this.nLNsCleanedThisRun;
                            Long offset = lookAheadCache.nextOffset();
                            LNInfo info = lookAheadCache.remove(offset);
                            ln = info.getLN();
                            byte[] key = info.getKey();
                            byte[] dupKey = info.getDupKey();
                            logLsn = DbLsn.makeLsn((long)fileNum, offset);
                            DatabaseImpl db = this.env.getDbTree().getDb(info.getDbId(), this.cleaner.lockTimeout, dbCache);
                            processedHere = true;
                            obsolete = false;
                            completed = false;
                            bin = null;
                            parentDIN = null;
                            try {
                                long treeLsn;
                                if (db == null || db.isDeleted()) {
                                    this.cleaner.addPendingDB(db);
                                    ++this.nLNsDeadThisRun;
                                    obsolete = true;
                                    completed = true;
                                    Object var31_17 = null;
                                    if (parentDIN == null) break block21;
                                    break block22;
                                }
                                Tree tree = db.getTree();
                                assert (tree != null);
                                boolean parentFound = tree.getParentBINForChildLN(location, key, dupKey, ln, false, true, false, Cleaner.UPDATE_GENERATION);
                                bin = location.bin;
                                int index = location.index;
                                if (!parentFound) {
                                    ++this.nLNsDeadThisRun;
                                    obsolete = true;
                                    completed = true;
                                    break block23;
                                }
                                if (bin.isEntryKnownDeleted(index)) {
                                    ++this.nLNsDeadThisRun;
                                    obsolete = true;
                                    completed = true;
                                    break block24;
                                }
                                boolean isDupCountLN = ln.containsDuplicates();
                                if (isDupCountLN) {
                                    parentDIN = (DIN)((BIN)bin).fetchTarget(index);
                                    parentDIN.latch(Cleaner.UPDATE_GENERATION);
                                    ChildReference dclRef = ((DIN)parentDIN).getDupCountLNRef();
                                    treeLsn = dclRef.getLsn();
                                } else {
                                    treeLsn = bin.getLsn(index);
                                }
                                processedHere = false;
                                this.processFoundLN(info, logLsn, treeLsn, (BIN)bin, index, (DIN)parentDIN);
                                completed = true;
                                if (!isDupCountLN) {
                                    boolean isBinInDupDwDb = db.isDeferredWriteMode() && db.getSortedDuplicates() && !bin.containsDuplicates();
                                    for (int i = 0; i < bin.getNEntries(); ++i) {
                                        void var29_32;
                                        long binLsn = bin.getLsn(i);
                                        if (i == index || bin.isEntryKnownDeleted(i) || bin.isEntryPendingDeleted(i) || DbLsn.getFileNumber(binLsn) != fileNum) continue;
                                        Long myOffset = DbLsn.getFileOffset(binLsn);
                                        if (isBinInDupDwDb && bin.getTarget(i) instanceof DIN) {
                                            Object var29_33 = null;
                                        } else {
                                            LNInfo lNInfo = lookAheadCache.remove(myOffset);
                                        }
                                        if (var29_32 == null) continue;
                                        ++this.nLNQueueHitsThisRun;
                                        ++this.nLNsCleanedThisRun;
                                        this.processFoundLN((LNInfo)var29_32, binLsn, binLsn, (BIN)bin, i, null);
                                    }
                                }
                                break block25;
                            }
                            catch (Throwable throwable) {
                                Object var31_21 = null;
                                if (parentDIN != null) {
                                    parentDIN.releaseLatch();
                                }
                                if (bin != null) {
                                    bin.releaseLatch();
                                }
                                if (!processedHere) throw throwable;
                                this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
                                throw throwable;
                            }
                        }
                        parentDIN.releaseLatch();
                    }
                    if (bin != null) {
                        bin.releaseLatch();
                    }
                    if (!processedHere) return;
                    this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
                    return;
                }
                Object var31_18 = null;
                if (parentDIN != null) {
                    parentDIN.releaseLatch();
                }
                if (bin != null) {
                    bin.releaseLatch();
                }
                if (!processedHere) return;
                this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
                return;
            }
            Object var31_19 = null;
            if (parentDIN != null) {
                parentDIN.releaseLatch();
            }
            if (bin != null) {
                bin.releaseLatch();
            }
            if (!processedHere) return;
            this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
            return;
        }
        Object var31_20 = null;
        if (parentDIN != null) {
            parentDIN.releaseLatch();
        }
        if (bin != null) {
            bin.releaseLatch();
        }
        if (!processedHere) return;
        this.cleaner.logFine("CleanLN:", ln, logLsn, completed, obsolete, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFoundLN(LNInfo info, long logLsn, long treeLsn, BIN bin, int index, DIN parentDIN) throws DatabaseException {
        boolean completed;
        boolean lockDenied;
        boolean migrated;
        boolean obsolete;
        boolean isTemporary;
        DatabaseImpl db;
        byte[] dupKey;
        byte[] key;
        LN lnFromLog;
        block36: {
            lnFromLog = info.getLN();
            key = info.getKey();
            dupKey = info.getDupKey();
            db = bin.getDatabase();
            isTemporary = db.isTemporary();
            boolean isDupCountLN = parentDIN != null;
            obsolete = false;
            migrated = false;
            lockDenied = false;
            completed = false;
            long nodeId = lnFromLog.getNodeId();
            Locker locker = null;
            try {
                Tree tree = db.getTree();
                assert (tree != null);
                if (lnFromLog.isDeleted() && treeLsn == logLsn && this.fileLogVersion <= 2) {
                    obsolete = true;
                    ++this.nLNsDeadThisRun;
                    bin.setPendingDeleted(index);
                } else if (treeLsn == -1L) {
                    obsolete = true;
                } else if (treeLsn != logLsn && isTemporary) {
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                } else if (treeLsn != logLsn || !this.cleaner.lazyMigration) {
                    locker = BasicLocker.createBasicLocker(this.env, false);
                    locker.setPreemptable(false);
                    LockResult lockRet = locker.nonBlockingLock(nodeId, LockType.READ, db);
                    if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                        ++this.nLNsLockedThisRun;
                        lockDenied = true;
                    } else if (treeLsn != logLsn) {
                        ++this.nLNsDeadThisRun;
                        obsolete = true;
                    }
                }
                if (!obsolete && !lockDenied) {
                    assert (treeLsn == logLsn);
                    if (isDupCountLN) {
                        ChildReference dclRef = parentDIN.getDupCountLNRef();
                        if (dclRef.getTarget() == null) {
                            lnFromLog.postFetchInit(db, logLsn);
                            parentDIN.updateDupCountLN(lnFromLog);
                        }
                        if (isTemporary) {
                            ((LN)dclRef.getTarget()).setDirty();
                            dclRef.setLsn(-1L);
                        } else if (this.cleaner.lazyMigration) {
                            dclRef.setMigrate(true);
                            parentDIN.setDirty(true);
                        } else {
                            LN targetLn = (LN)dclRef.getTarget();
                            assert (targetLn != null);
                            byte[] targetKey = parentDIN.getDupKey();
                            long newLNLsn = targetLn.log(this.env, db, targetKey, logLsn, locker, true, ReplicationContext.NO_REPLICATE);
                            parentDIN.updateDupCountLNRef(newLNLsn);
                            if (lnFromLog == targetLn) {
                                parentDIN.updateDupCountLN(null);
                            }
                        }
                    } else {
                        if (bin.getTarget(index) == null) {
                            lnFromLog.postFetchInit(db, logLsn);
                            byte[] lnSlotKey = bin.containsDuplicates() ? dupKey : key;
                            bin.updateNode(index, lnFromLog, lnSlotKey);
                        }
                        if (isTemporary) {
                            ((LN)bin.getTarget(index)).setDirty();
                            bin.clearLsn(index);
                        } else if (this.cleaner.lazyMigration) {
                            bin.setMigrate(index, true);
                            bin.setDirty(true);
                        } else {
                            LN targetLn = (LN)bin.getTarget(index);
                            assert (targetLn != null);
                            byte[] targetKey = this.cleaner.getLNMainKey(bin, index);
                            long newLNLsn = targetLn.log(this.env, db, targetKey, logLsn, locker, true, ReplicationContext.NO_REPLICATE);
                            bin.updateEntry(index, newLNLsn);
                            if (lnFromLog == targetLn) {
                                bin.updateNode(index, null, null);
                            }
                        }
                        bin.setGeneration(CacheMode.DEFAULT);
                    }
                    ++this.nLNsMarkedThisRun;
                    migrated = true;
                }
                completed = true;
                Object var29_26 = null;
                if (locker == null) break block36;
            }
            catch (Throwable throwable) {
                Object var29_27 = null;
                if (locker != null) {
                    locker.operationEnd();
                }
                if (completed && lockDenied) {
                    assert (!isTemporary);
                    this.fileSelector.addPendingLN(lnFromLog, db.getId(), key, dupKey);
                }
                this.cleaner.logFine("CleanLN:", lnFromLog, logLsn, completed, obsolete, migrated);
                throw throwable;
            }
            locker.operationEnd();
        }
        if (completed && lockDenied) {
            assert (!isTemporary);
            this.fileSelector.addPendingLN(lnFromLog, db.getId(), key, dupKey);
        }
        this.cleaner.logFine("CleanLN:", lnFromLog, logLsn, completed, obsolete, migrated);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, long logLsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            ++this.nINsCleanedThisRun;
            if (db == null || db.isDeleted()) {
                this.cleaner.addPendingDB(db);
                ++this.nINsDeadThisRun;
                obsolete = true;
                completed = true;
                Object var11_7 = null;
                this.cleaner.logFine("CleanIN:", inClone, logLsn, completed, obsolete, dirtied);
                return;
            }
            Tree tree = db.getTree();
            assert (tree != null);
            IN inInTree = this.findINInTree(tree, db, inClone, logLsn);
            if (inInTree == null) {
                ++this.nINsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setProhibitNextDelta();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            this.cleaner.logFine("CleanIN:", inClone, logLsn, completed, obsolete, dirtied);
            throw throwable;
        }
        Object var11_8 = null;
        this.cleaner.logFine("CleanIN:", inClone, logLsn, completed, obsolete, dirtied);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, long logLsn) throws DatabaseException {
        IN in;
        int compareVal;
        SearchResult result;
        block16: {
            long treeLsn;
            block15: {
                block14: {
                    if (inClone.isDbRoot()) {
                        IN rootIN = this.isRoot(tree, db, inClone, logLsn);
                        if (rootIN == null) {
                            return null;
                        }
                        return rootIN;
                    }
                    inClone.latch(Cleaner.UPDATE_GENERATION);
                    result = null;
                    try {
                        result = tree.getParentINForChildIN(inClone, true, Cleaner.UPDATE_GENERATION, inClone.getLevel(), null);
                        if (result.exactParentFound) break block14;
                        IN iN = null;
                        Object var13_9 = null;
                        if (result != null && result.exactParentFound) {
                            result.parent.releaseLatch();
                        }
                        return iN;
                    }
                    catch (Throwable throwable) {
                        block17: {
                            Object var13_13 = null;
                            if (result == null || !result.exactParentFound) break block17;
                            result.parent.releaseLatch();
                        }
                        throw throwable;
                    }
                }
                treeLsn = result.parent.getLsn(result.index);
                if (treeLsn != -1L) break block15;
                IN iN = null;
                Object var13_10 = null;
                if (result != null && result.exactParentFound) {
                    result.parent.releaseLatch();
                }
                return iN;
            }
            compareVal = DbLsn.compareTo(treeLsn, logLsn);
            if (compareVal <= 0) break block16;
            IN iN = null;
            Object var13_11 = null;
            if (result != null && result.exactParentFound) {
                result.parent.releaseLatch();
            }
            return iN;
        }
        if (compareVal == 0) {
            in = (IN)result.parent.getTarget(result.index);
            if (in == null) {
                in = inClone;
                in.postFetchInit(db, logLsn);
                result.parent.updateNode(result.index, in, null);
            }
        } else {
            in = (IN)result.parent.fetchTargetWithExclusiveLatch(result.index);
        }
        in.latch(Cleaner.UPDATE_GENERATION);
        IN iN = in;
        Object var13_12 = null;
        if (result != null && result.exactParentFound) {
            result.parent.releaseLatch();
        }
        return iN;
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatchedShared(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsObsoleteThisRun = 0;
        this.nINsCleanedThisRun = 0;
        this.nINsDeadThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsObsoleteThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsMarkedThisRun = 0;
        this.nLNQueueHitsThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.cleaner.nINsObsolete.add(this.nINsObsoleteThisRun);
        this.cleaner.nINsCleaned.add(this.nINsCleanedThisRun);
        this.cleaner.nINsDead.add(this.nINsDeadThisRun);
        this.cleaner.nINsMigrated.add(this.nINsMigratedThisRun);
        this.cleaner.nLNsObsolete.add(this.nLNsObsoleteThisRun);
        this.cleaner.nLNsCleaned.add(this.nLNsCleanedThisRun);
        this.cleaner.nLNsDead.add(this.nLNsDeadThisRun);
        this.cleaner.nLNsMigrated.add(this.nLNsMigratedThisRun);
        this.cleaner.nLNsMarked.add(this.nLNsMarkedThisRun);
        this.cleaner.nLNQueueHits.add(this.nLNQueueHitsThisRun);
        this.cleaner.nLNsLocked.add(this.nLNsLockedThisRun);
        this.cleaner.nRepeatIteratorReads.add(this.nRepeatIteratorReadsThisRun);
    }

    private static class LookAheadCache {
        private final SortedMap<Long, LNInfo> map = new TreeMap<Long, LNInfo>();
        private final int maxMem;
        private int usedMem;

        LookAheadCache(int lookAheadCacheSize) {
            this.maxMem = lookAheadCacheSize;
            this.usedMem = MemoryBudget.TREEMAP_OVERHEAD;
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        boolean isFull() {
            return this.usedMem >= this.maxMem;
        }

        Long nextOffset() {
            return this.map.firstKey();
        }

        void add(Long lsnOffset, LNInfo info) {
            this.map.put(lsnOffset, info);
            this.usedMem += info.getMemorySize();
            this.usedMem += MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
        }

        LNInfo remove(Long offset) {
            LNInfo info = (LNInfo)this.map.remove(offset);
            if (info != null) {
                this.usedMem -= info.getMemorySize();
                this.usedMem -= MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
            }
            return info;
        }
    }

    private static class RootDoWork
    implements WithRootLatched {
        private final DatabaseImpl db;
        private final IN inClone;
        private final long logLsn;

        RootDoWork(DatabaseImpl db, IN inClone, long logLsn) {
            this.db = db;
            this.inClone = inClone;
            this.logLsn = logLsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || root.getLsn() == -1L || root.fetchTarget(this.db, null).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (DbLsn.compareTo(root.getLsn(), this.logLsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch(Cleaner.UPDATE_GENERATION);
                return rootIN;
            }
            return null;
        }
    }
}

