package org.maachang.reflect ;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

/**
 * コンストラクタ要素群.
 *
 * @version 2009/03/31
 * @author  masahito suzuki
 * @since   FastReflect 1.00
 */
class FastConstructorElements {
    /** コンストラクタ情報格納用 **/
    private static class FastConstructorEmt {
        /** コンストラクタオブジェクト **/
        protected Constructor constructor ;
        
        /** コンストラクタ引数. **/
        protected Class[] params ;
        
        /** コンストラクタ引数長 **/
        protected int paramsLength ;
        
        /** コンストラクタ. **/
        protected FastConstructorEmt( Constructor constructor )
            throws Exception {
            Class[] args = constructor.getParameterTypes() ;
            int len = ( args == null ) ? 0 : args.length ;
            if( len == 0 ) {
                args = FastReflectPrimitive.NO_PARAM_CLASS ;
            }
            else {
                Class pc ;
                for( int i = 0 ; i < len ; i ++ ) {
                    pc = FastReflectPrimitive.CONV_PRIMITIVE.get( args[ i ] ) ;
                    if( pc != null ) {
                        args[ i ] = pc ;
                    }
                }
            }
            constructor.setAccessible( true ) ;
            this.constructor = constructor ;
            this.params = args ;
            this.paramsLength = len ;
        }
    }
    
    /** フィールド格納Map. **/
    private final List<FastConstructorEmt> list = new ArrayList<FastConstructorEmt>() ;
    
    /**
     * コンストラクタ.
     */
    private FastConstructorElements() {}
    
    /**
     * コンストラクタ.
     * @param clazz 対象のクラスオブジェクトを設定します.
     * @exception Exception 例外.
     */
    public FastConstructorElements( Class clazz ) throws Exception {
        Constructor[] cs = clazz.getDeclaredConstructors() ;
        if( cs != null ) {
            int len = cs.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                // publicのみキャッシュ.
                Constructor c = cs[ i ] ;
                if( Modifier.isPublic( c.getModifiers() ) ) {
                    list.add( new FastConstructorEmt( c ) ) ;
                }
            }
        }
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        list.clear() ;
    }
    
    /**
     * 指定名のコンストラクタを実行.
     * @param clazz 対象のクラスオブジェクトを設定します.
     * @param cl 対象のクラスローダを設定します.
     * @param types 対象のパラメータタイプを設定します.
     * @param args 引数パラメータ型群を設定します.
     * @return Object [null]の場合、存在しません.
     * @exception Exception 例外.
     */
    public Object newInstance( Class clazz,ClassLoader cl,Class[] types,Object[] args )
        throws Exception {
        int len = list.size() ;
        int argsLen = ( args == null ) ? 0 : args.length ;
        if( argsLen == 0 ) {
            for( int i = 0 ; i < len ; i ++ ) {
                FastConstructorEmt emt = list.get( i ) ;
                if( emt.paramsLength == 0 ) {
                    return emt.constructor.newInstance( FastReflectPrimitive.NO_PARAM ) ;
                }
            }
        }
        else {
            int pf = 100 * argsLen ;
            int score = -1 ;
            FastConstructorEmt targetEmt = null ;
            for( int i = 0 ; i < len ; i ++ ) {
                FastConstructorEmt emt = list.get( i ) ;
                if( emt.paramsLength == argsLen ) {
                    int sc = FastReflectUtil.parmasScore( emt.params,types,cl ) ;
                    if( sc != -1 && score < sc ) {
                        if( sc == pf ) {
                            return emt.constructor.newInstance( args ) ;
                        }
                        score = sc ;
                        targetEmt = emt ;
                    }
                }
            }
            if( targetEmt != null ) {
                args = FastReflectUtil.convertParams( args,targetEmt.params ) ;
                return targetEmt.constructor.newInstance( args ) ;
            }
        }
        return null ;
    }
}
