package org.maachang.html;

/**
 * HTML-表示情報.
 * 
 * @version 2009/02/13
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
public class HtmlView implements HtmlElement {
    private String view = "" ;
    private int listNo = -1 ;
    
    /**
     * コンストラクタ.
     */
    public HtmlView() {
        this.view = "" ;
    }
    
    /**
     * コンストラクタ.
     * @param view 内容を設定します.
     */
    public HtmlView( String view ) {
        this.set( view ) ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        view = "" ;
    }
    
    /**
     * 情報設定.
     * @param view 内容を設定します.
     */
    public void set( String view ) {
        if( view == null || ( view = view.trim() ).length() <= 0 ) {
            view = "" ;
        }
        this.view = view ;
    }
    
    /**
     * 情報取得.
     * @return String 内容が返されます.
     */
    public String get() {
        return view ;
    }
    
    /**
     * 現在の格納位置を項番で取得.
     * @return int 現在の格納位置が返されます.
     */
    public int getListNo() {
        return listNo ;
    }
    
    /**
     * 現在の格納位置を項番で設定.
     * @param no 現在の格納位置を設定します.
     */
    public void setListNo( int no ) {
        listNo = no ;
    }
    
    /**
     * StringBuilderに内容を出力.
     * @param buf 対象のStringBuilderを設定します.
     */
    public void toString( StringBuilder buf ) {
        buf.append( view ) ;
    }
    
    /**
     * 文字列として出力.
     * @return String 文字列が返されます.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder() ;
        toString( buf ) ;
        return buf.toString() ;
    }
}
