package org.maachang.html;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;

/**
 * HTMLユーティリティ.
 * 
 * @version 2009/02/14
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
abstract class HtmlUtil {
    private HtmlUtil() {}
    
    protected static final String trim( String string ) {
        int s = -1 ;
        int e = -1 ;
        int len = string.length() ;
        s = 0 ;
        boolean sFlg = false ;
        for( int i = 0 ; i < len ; i ++ ) {
            char c = string.charAt( i ) ;
            if( c != ' '  && c != '　' && c != '\r' && c != '\n' && c != '\t' ) {
                s = i ;
                break ;
            }
            sFlg = true ;
        }
        e = len-1 ;
        boolean eFlg = false ;
        for( int i = len-1 ; i >= 0 ; i -- ) {
            char c = string.charAt( i ) ;
            if( c != ' '  && c != '　' && c != '\r' && c != '\n' && c != '\t' ) {
                e = i ;
                break ;
            }
            eFlg = true ;
        }
        if( sFlg == true && eFlg == true ) {
            return string.substring( s,e+1 ) ;
        }
        else if( sFlg == true ) {
            return string.substring( s ) ;
        }
        else if( eFlg == true ) {
            return string.substring( 0,e+1 ) ;
        }
        return string ;
    }
    
    protected static final int indexCote( String base,String cc,int off ) throws IOException {
        int len = base.length() ;
        int cote = -1 ;
        char[] ck = cc.toCharArray() ;
        int cLen = ck.length ;
        char bef = 0 ;
        boolean yenFlag = false ;
        for( int i = off ; i < len ; i ++ ) {
            char c = base.charAt( i ) ;
            if( cote != -1 ) {
                if( bef != '\\' && c == cote ) {
                    yenFlag = false ;
                    cote = -1 ;
                }
                else if( c == '\\' && bef == '\\' ) {
                    yenFlag = true ;
                }
                else {
                    yenFlag = false ;
                }
            }
            else {
                if( bef != '\\' && ( c == '\'' || c == '\"' ) ) {
                    cote = c ;
                }
                else if( c == ck[ 0 ] ) {
                    boolean res = true ;
                    for( int j = 1 ; j < cLen ; j ++ ) {
                        if( i + j >= len || ck[ j ] != base.charAt( i + j ) ) {
                            res = false ;
                            break ;
                        }
                    }
                    if( res == true ) {
                        return i ;
                    }
                }
            }
            if( yenFlag ) {
                yenFlag = false ;
                bef = 0 ;
            }
            else {
                bef = c ;
            }
        }
        return -1 ;
    }
    
    protected static final int indexParCote( String base,char st,char ed,int off )
        throws IOException {
        int len = base.length() ;
        int par = -1 ;
        int cote = -1 ;
        int idx = 0 ;
        int bef = 0 ;
        boolean yenFlag = false ;
        for( int i = off ; i < len ; i ++ ) {
            char c = base.charAt( i ) ;
            if( par != -1 || cote != -1 ) {
                if( cote != -1 ) {
                    if( bef != '\\' && c == cote ) {
                        yenFlag = false ;
                        cote = -1 ;
                    }
                    else if( c == '\\' && bef == '\\' ) {
                        yenFlag = true ;
                    }
                    else {
                        yenFlag = false ;
                    }
                }
                else if( par != -1 ) {
                    if( c == ed ) {
                        idx -- ;
                        if( idx <= 0 ) {
                            return i ;
                        }
                    }
                    else if( c == st ) {
                        idx ++ ;
                    }
                }
            }
            else {
                if( c == '\'' || c == '\"' ) {
                    cote = c ;
                }
                else if( c == st ) {
                    idx = 1 ;
                    par = c ;
                }
                else if( c == ed ) {
                    return i ;
                }
            }
            if( yenFlag ) {
                yenFlag = false ;
                bef = 0 ;
            }
            else {
                bef = c ;
            }
        }
        return -1 ;
    }
    
    protected static final String cutEnter( String string ) {
        if( string == null || ( string = trim( string ) ).length() <= 0 ) {
            return "" ;
        }
        StringBuilder buf = new StringBuilder() ;
        int len = string.length() ;
        int cote = -1 ;
        int bef = 0 ;
        boolean yenFlag = false ;
        for( int i = 0 ; i < len ; i ++ ) {
            char c = string.charAt( i ) ;
            if( cote != -1 ) {
                if( bef != '\\' && c == cote ) {
                    yenFlag = false ;
                    cote = -1 ;
                }
                else if( c == '\\' && bef == '\\' ) {
                    yenFlag = true ;
                }
                else {
                    yenFlag = false ;
                }
            }
            else if( c == '\'' || c == '\"' ) {
                cote = c ;
            }
            if( c == '\r' || c == '\n' ) {
                if( cote == -1 ) {
                    buf.append( " " ) ;
                }
                continue ;
            }
            buf.append( c ) ;
            if( yenFlag ) {
                yenFlag = false ;
                bef = 0 ;
            }
            else {
                bef = c ;
            }
        }
        return buf.toString().trim() ;
    }
    
    protected static final String getFileByString(String name, String charset)
            throws Exception {
        int len;
        char[] tmp = null;
        CharArrayWriter ca = null;
        Reader buf = null;
        String ret = null;
        try {
            tmp = new char[8192];
            ca = new CharArrayWriter();
            buf = new BufferedReader(
                new InputStreamReader( new FileInputStream( name ),charset) ) ;
            while ((len = buf.read(tmp, 0, 8192)) > 0) {
                ca.write(tmp, 0, len);
            }
            ret = ca.toString();
            ca.close();
            ca = null;
            buf.close() ;
            buf = null ;
        } finally {
            if( buf != null ) {
                try {
                    buf.close();
                } catch (Exception t) {
                }
            }
            if( ca != null ) {
                try {
                    ca.close();
                } catch (Exception t) {
                }
            }
            buf = null;
            ca = null;
            tmp = null;
        }
        return ret;
    }
    
    protected static final void setFileByString(String name, boolean mode,
            String value, String charset) throws Exception {
        BufferedWriter buf = null;
        if (name == null || value == null) {
            throw new IllegalArgumentException("引数は不正です");
        }
        try {
            buf = new BufferedWriter(new OutputStreamWriter(
                    new FileOutputStream( name,!mode ), charset));
            buf.write(value);
            buf.flush() ;
            buf.close() ;
            buf = null ;
        } catch (Exception e) {
            throw e;
        } finally {
            if( buf != null ) {
                try {
                    buf.close();
                } catch (Exception t) {
                }
                buf = null;
            }
        }
    }
    
    protected static final boolean isFileExists(String name) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = (file.exists() == true) ? ((file.isDirectory() == false) ? file
                    .canRead()
                    : false)
                    : false;
        } catch (Exception e) {
            ret = false;
        }
        return ret;
    }

}
