package org.maachang.html;

/**
 * HTML-タグ要素：シンボル情報.
 * 
 * @version 2009/02/13
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
public class HtmlTagSimbol implements HtmlTagElement {
    private String simbol = "" ;
    
    /**
     * コンストラクタ.
     */
    public HtmlTagSimbol() {
        this.simbol = "" ;
    }
    
    /**
     * コンストラクタ.
     * @param simbol 対象のシンボルを設定します.
     */
    public HtmlTagSimbol( String simbol ) {
        this.set( simbol ) ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        simbol = "" ;
    }
    
    /**
     * タグ要素条件を取得.
     * @return int タグ要素条件が返されます.
     */
    public int getType() {
        return SIMBOL ;
    }
    
    /**
     * 情報設定.
     * @param simbol 対象のシンボルを設定します.
     */
    public void set( String simbol ) {
        if( simbol == null || ( simbol = HtmlUtil.trim( simbol ) ).length() <= 0 ) {
            simbol = "" ;
        }
        this.simbol = simbol.toLowerCase() ;
    }
    
    /**
     * 情報取得.
     * @return String シンボル情報が返されます.
     */
    public String get() {
        return simbol ;
    }
    
    /**
     * StringBuilderに内容を出力.
     * @param buf 対象のStringBuilderを設定します.
     */
    public void toString( StringBuilder buf ) {
        buf.append( simbol ) ;
    }
}
