package org.maachang.html;

/**
 * HTML-タグ要素：Key/Value情報.
 * 
 * @version 2009/02/13
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
public class HtmlTagKeyValue implements HtmlTagElement {
    private String key = "" ;
    private String value = "" ;
    
    /**
     * コンストラクタ.
     */
    public HtmlTagKeyValue() {
        this.key = "" ;
        this.value = "" ;
    }
    
    /**
     * コンストラクタ.
     * @param key 対象のKey名を設定します.
     * @param value 対象の要素を設定します.
     */
    public HtmlTagKeyValue( String key,String value ) {
        this.set( key,value ) ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        key = "" ;
        value = "" ;
    }
    
    /**
     * タグ要素条件を取得.
     * @return int タグ要素条件が返されます.
     */
    public int getType() {
        return KEY_VALUE ;
    }
    
    /**
     * 情報設定.
     * @param key 対象のKey名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void set( String key,String value ) {
        if( key == null || ( key = HtmlUtil.trim( key ) ).length() <= 0 ) {
            throw new IllegalArgumentException( "タグ要素のKey情報が不正です" ) ;
        }
        this.key = key.toLowerCase() ;
        if( value == null || value.length() <= 0 ) {
            value = "" ;
        }
        this.value = value ;
    }
    
    /**
     * 情報取得.
     * @return String キー情報が返されます.
     */
    public String get() {
        return key ;
    }
    
    /**
     * キー情報取得.
     * @return String キー情報が返されます.
     */
    public String getKey() {
        return key ;
    }
    
    /**
     * 要素情報取得.
     * @return String 要素情報が返されます.
     */
    public String getValue() {
        return value ;
    }
    
    /**
     * StringBuilderに内容を出力.
     * @param buf 対象のStringBuilderを設定します.
     */
    public void toString( StringBuilder buf ) {
        String c = "\"" ;
        if( value.indexOf( "\'" ) == -1 ) {
            c = "\'" ;
        }
        buf.append( key ).append( "=" ).append( c ).append( value ).append( c ) ;
    }
    
    /**
     * StringBuilderに内容を出力.
     * @param buf 対象のStringBuilderを設定します.
     */
    public void toSmart( StringBuilder buf ) {
        if( checkNoCote( value ) ) {
            buf.append( key ).append( "=" ).append( value ) ;
        }
        else {
            String c = "\"" ;
            if( value.indexOf( "\'" ) == -1 ) {
                c = "\'" ;
            }
            buf.append( key ).append( "=" ).append( c ).append( value ).append( c ) ;
        }
    }
    
    private boolean checkNoCote( String value ) {
        if( value == null || value.length() <= 0 ) {
            return true ;
        }
        int len = value.length() ;
        for( int i = 0 ; i < len ; i ++ ) {
            char c = value.charAt( i ) ;
            if( c == '\'' || c == '\"' ||
                c == ' ' || c == '\t' || c == '\r' || c == '\n' ) {
                return false ;
            }
        }
        return true ;
    }
}
