package org.maachang.html;

/**
 * HTML要素を示すインターフェイス.
 * 
 * @version 2009/02/13
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
public interface HtmlTagElement {
    
    /**
     * タグ要素条件 : Key/Value条件.
     */
    public static final int KEY_VALUE = 0 ;
    
    /**
     * タグ要素条件 : シンボル条件.
     */
    public static final int SIMBOL = 1 ;
    
    /**
     * タグ要素条件を取得.
     * @return int タグ要素条件が返されます.
     */
    public int getType() ;
    
    /**
     * 内容を取得.
     * @return String 内容が返されます.
     */
    public String get() ;
    
    /**
     * StringBuilderに内容を出力.
     * @param buf 対象のStringBuilderを設定します.
     */
    public void toString( StringBuilder buf ) ;
}
