package org.maachang.html;

/**
 * HTML-要素リスト.
 * 
 * @version 2009/02/14
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
class HtmlElementList {
    private static final double REDUCTION_ARRAY = 0.375;
    private static final int DEFAULT_START_LENGTH = 8;
    private static final int MAX_START_LENGTH = Integer.MAX_VALUE;
    private static final int MIN_START_LENGTH = 2;
    private HtmlElement[] array = null;
    private int startLength = DEFAULT_START_LENGTH;
    private int length = DEFAULT_START_LENGTH;
    private int nowLength = 0;
    
    public HtmlElementList() {
    }
    
    public HtmlElementList(int length) {
        this.startLength = (length < MIN_START_LENGTH || length > MAX_START_LENGTH) ?
            DEFAULT_START_LENGTH : length;
        this.length = this.startLength;
    }
    
    protected final void finalize() throws Exception {
        try {
            this.clear();
        } catch (Exception t) {
        }
    }
    
    public final void clear() {
        this.array = null;
        this.length = this.startLength;
        this.nowLength = 0;
    }
    
    public final void add(HtmlElement value) {
        HtmlElement[] info = this.array;
        int length = this.length;
        int nowSize = this.nowLength;
        if (info == null) {
            info = new HtmlElement[length];
            info[nowSize] = value;
            info[nowSize].setListNo( nowSize ) ;
            this.array = info;
        } else if (info.length <= nowSize) {
            length *= 2;
            HtmlElement[] tmp = info;
            info = new HtmlElement[length];
            arraycopy(tmp, 0, info, 0, nowSize);
            info[nowSize] = value;
            info[nowSize].setListNo( nowSize ) ;
            this.length = length;
            this.array = info;
        } else {
            info[nowSize] = value;
            info[nowSize].setListNo( nowSize ) ;
        }
        this.nowLength++;
    }
    
    public final HtmlElement set(int no, HtmlElement value) {
        int nowLen;
        nowLen = this.nowLength;
        if (no < 0 || no >= nowLen) {
            return null ;
        }
        HtmlElement ret = array[no] ;
        this.array[no] = value;
        this.array[no].setListNo( no ) ;
        ret.setListNo( -1 ) ;
        return ret ;
    }
    
    public final void insert( int no, HtmlElement value ) {
        HtmlElement[] info = this.array;
        int length = this.length;
        int nowSize = this.nowLength;
        if( info == null || no >= nowSize ) {
            add( value ) ;
            return ;
        }
        if (info.length <= nowSize) {
            length *= 2;
            HtmlElement[] tmp = info;
            info = new HtmlElement[length];
            arraycopy(tmp, 0, info, 0, nowSize);
            this.length = length;
            this.array = info;
        }
        if( no <= 0 ) {
            for( int i = nowLength-1 ; i >= 0 ; i -- ) {
                info[ i+1 ] = info[ i ] ;
                info[ i+1 ].setListNo( i+1 ) ;
            }
            info[ 0 ] = value ;
            info[ 0 ].setListNo( 0 ) ;
        }
        else {
            for( int i = nowLength-1 ; i >= no ; i -- ) {
                info[ i+1 ] = info[ i ] ;
                info[ i+1 ].setListNo( i+1 ) ;
            }
            info[ no ] = value ;
            info[ no ].setListNo( no ) ;
        }
        this.nowLength++;
    }
    
    public final HtmlElement remove(int no) {
        HtmlElement ret = null;
        int nowSize = this.nowLength;
        int length = this.length;
        if (no < 0 || no >= nowSize || nowSize == 0) {
            return null;
        }
        HtmlElement[] info = this.array;
        ret = info[no];
        info[no] = null;
        if (no == 0) {
            HtmlElement[] tmp = info;
            arraycopy(tmp, 1, info, 0, (nowSize - 1));
            info[nowSize - 1] = null;
        } else if ((nowSize - no) != 1) {
            HtmlElement[] tmp = info;
            arraycopy(tmp, 0, info, 0, no);
            arraycopy(tmp, no + 1, info, no, nowSize - (no + 1));
            info[nowSize - 1] = null;
        }
        nowSize--;
        if (nowSize != 0 && (length * REDUCTION_ARRAY) >= nowSize) {
            int newLength = length / 2;
            HtmlElement[] tmp = new HtmlElement[newLength];
            arraycopy(info, 0, tmp, 0, newLength);
            info = tmp;
            this.length = newLength;
        } else if (nowSize == 0) {
            info = null;
        }
        this.array = info;
        this.nowLength = nowSize;
        ret.setListNo( -1 ) ;
        return ret;
    }
    
    public final HtmlElement get(int no) {
        if (no < 0 || no >= this.nowLength) {
            return null;
        }
        return this.array[no];
    }
    
    public final int size() {
        return this.nowLength;
    }
    
    private static final void arraycopy( HtmlElement[] src,int srcPos,HtmlElement[] dest,int destPos,int len ) {
        for( int i = 0 ; i < len ; i ++ ) {
            int dPos = destPos + i ;
            if( src[srcPos+i] == null ) {
            	dest[dPos] = null ;
            }
            else {
	            dest[ dPos ] = src[ srcPos+i ] ;
	            dest[ dPos ].setListNo( dPos ) ;
            }
        }
    }
    
}
