package org.maachang.html;

/**
 * HTML-コメント情報.
 * 
 * @version 2009/02/13
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
public class HtmlComment implements HtmlElement {
    private String comment = "" ;
    private int listNo = -1 ;
    
    /**
     * コンストラクタ.
     */
    public HtmlComment() {
        this.comment = "" ;
    }
    
    /**
     * コンストラクタ.
     * @param comment コメント内容を設定します.
     */
    public HtmlComment( String comment ) {
        this.set( comment ) ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        comment = "" ;
    }
    
    /**
     * 情報設定.
     * @param comment コメント内容を設定します.
     */
    public void set( String comment ) {
        if( comment == null || ( comment = HtmlUtil.trim( comment ) ).length() <= 0 ) {
            comment = "" ;
        }
        this.comment = comment ;
    }
    
    /**
     * 情報取得.
     * @return String コメント内容が返されます.
     */
    public String get() {
        return comment ;
    }
    
    /**
     * 現在の格納位置を項番で取得.
     * @return int 現在の格納位置が返されます.
     */
    public int getListNo() {
        return listNo ;
    }
    
    /**
     * 現在の格納位置を項番で設定.
     * @param no 現在の格納位置を設定します.
     */
    public void setListNo( int no ) {
        listNo = no ;
    }
    
    /**
     * StringBuilderに内容を出力.
     * @param buf 対象のStringBuilderを設定します.
     */
    public void toString( StringBuilder buf ) {
        buf.append( "<!-- " ).append( comment ).append( " -->" ) ;
    }
    
    /**
     * 文字列として出力.
     * @return String 文字列が返されます.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder() ;
        toString( buf ) ;
        return buf.toString() ;
    }
}
