package org.maachang.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * HTML解析処理.
 * 
 * @version 2009/02/14
 * @author  masahito suzuki
 * @since   SimpleHtmlParser 1.0.0
 */
abstract class HtmlAnalysis {
    private HtmlAnalysis() {}
    
    protected static final void analysis( int no,Html parent,Map<String,HtmlElement> tagId,HtmlElementList out,String string )
        throws IOException {
        if( no <= -1 ) {
            no = -1 ;
        }
        int[] o = new int[ 2 ] ;
        int b = 0 ;
        if( !startTagPos( o,string,b ) ) {
            string = string.trim() ;
            if( string.length() > 0 ) {
                if( no <= -1 ) {
                    out.add( new HtmlView( string ) ) ;
                }
                else {
                    out.insert( no,new HtmlView( string ) ) ;
                    no ++ ;
                }
            }
            return ;
        }
        int p = o[ 0 ] ;
        int e = o[ 1 ] ;
        if( p > 0 ) {
            String s = string.substring( b,p ).trim() ;
            if( s.length() > 0 ) {
                if( no <= -1 ) {
                    out.add( new HtmlView( s ) ) ;
                }
                else {
                    out.insert( no,new HtmlView( s ) ) ;
                    no ++ ;
                }
            }
        }
        while( true ) {
            String t = string.substring( p,e+1 ) ;
            if( t.charAt( 1 ) == '!' && t.charAt( 2 ) == '-' &&
                t.charAt( 3 ) == '-' ) {
                t = t.substring( "<!--".length(),t.length()-"-->".length() ).trim() ;
                if( t.length() > 0 ) {
                    if( no <= -1 ) {
                        out.add( new HtmlComment( t ) ) ;
                    }
                    else {
                        out.insert( no,new HtmlComment( t ) ) ;
                        no ++ ;
                    }
                }
            }
            else {
                String s = t.substring( 1,t.length()-1 ).trim() ;
                if( s.length() <= 0 || s.toLowerCase().startsWith( "!doctype" ) ) {
                    if( no <= -1 ) {
                        out.add( new HtmlView( t ) ) ;
                    }
                    else {
                        out.insert( no,new HtmlView( t ) ) ;
                        no ++ ;
                    }
                }
                else {
                    t = HtmlUtil.cutEnter( t ) ;
                    HtmlTag tg = HtmlTag.convert( t ) ;
                    if( no <= -1 ) {
                        out.add( tg ) ;
                    }
                    else {
                        out.insert( no,tg ) ;
                        no ++ ;
                    }
                    if( tg.getId() != null ) {
                        tagId.put( tg.getId(),tg ) ;
                    }
                    tg.setParent( parent ) ;
                }
            }
            b = e+1 ;
            if( !startTagPos( o,string,b ) ) {
                String s = string.substring( b ).trim() ;
                if( s.length() > 0 ) {
                    if( no <= -1 ) {
                        out.add( new HtmlView( s ) ) ;
                    }
                    else {
                        out.insert( no,new HtmlView( s ) ) ;
                        no ++ ;
                    }
                }
                return ;
            }
            p = o[ 0 ] ;
            e = o[ 1 ] ;
            if( b != p ) {
                String s = string.substring( b,p ).trim() ;
                if( s.length() > 0 ) {
                    if( no <= -1 ) {
                        out.add( new HtmlView( s ) ) ;
                    }
                    else {
                        out.insert( no,new HtmlView( s ) ) ;
                        no ++ ;
                    }
                }
            }
        }
    }
    
    protected static final String getTagName( int[] out,String string )
        throws IOException {
        int s = -1 ;
        int len = string.length() ;
        for( int i = 0 ; i < len ; i ++ ) {
            char c = string.charAt( i ) ;
            if( c != ' '  && c != '　' && c != '\r' && c != '\n' && c != '\t' ) {
                if( c == '/' ) {
                    continue ;
                }
                s = i ;
                break ;
            }
        }
        if( s == -1 ) {
            throw new IOException( "不正なタグ条件が存在します[" + string + "]" ) ;
        }
        int p = -1 ;
        for( int i = s ; i < len ; i ++ ) {
            char c = string.charAt( i ) ;
            if( c == ' '  || c == '　' || c == '\r' || c == '\n' || c == '\t' || c == '>' ) {
                p = i ;
                break ;
            }
        }
        if( p == -1 ) {
            out[ 0 ] = string.length() ;
            return HtmlUtil.trim( string.substring( s ).toLowerCase() ) ;
        }
        out[ 0 ] = p ;
        return HtmlUtil.trim( string.substring( s,p ).toLowerCase() ) ;
    }
    
    protected static final void cutElement( List<HtmlTagElement> out,String string )
        throws IOException {
        if( string == null || ( string = HtmlUtil.trim( string ) ).length() <= 0 ) {
            return ;
        }
        int len = string.length() ;
        int cote = -1 ;
        int s = -1 ;
        int bf = -1 ;
        int eq = 0 ;
        String key = null ;
        String value = null ;
        boolean yenFlag = false ;
        for( int i = 0 ; i < len ; i ++ ) {
            char c = string.charAt( i ) ;
            if( cote != -1 ) {
                if( c == cote && bf != '\\' ) {
                    yenFlag = false ;
                    cote = -1 ;
                    if( key != null ) {
                        value = string.substring( s+1,i ) ;
                        HtmlTagKeyValue kv = new HtmlTagKeyValue( key,value ) ;
                        out.add( kv ) ;
                        key = null ;
                        value = null ;
                        eq = 0 ;
                        s = -1 ;
                    }
                    else {
                        throw new IOException( "不正な要素内容が存在します[" + string + "]...pos:" + i ) ;
                    }
                }
                else if( c == '\\' && bf == '\\' ) {
                    yenFlag = true ;
                }
                else {
                    yenFlag = false ;
                }
            }
            else {
                if( c == '\'' || c == '\"' ) {
                    if( s != -1 ) {
                        throw new IOException( "不正な要素内容が存在します[" + string + "]...pos:" + i ) ;
                    }
                    else if( key == null ) {
                        throw new IOException( "不正な要素内容が存在します[" + string + "]...pos:" + i ) ;
                    }
                    else if( bf == '\\' ) {
                        throw new IOException( "不正なコーテーション内容が存在します[" + string + "]...pos:" + i ) ;
                    }
                    cote = c ;
                    s = i ;
                    continue ;
                }
                else if( c == '\r' || c == '\n' || c == ' ' || c == '　' || c == '\t' ) {
                    if( eq == 0 ) {
                        if( s != -1 ) {
                            if( key != null ) {
                                HtmlTagSimbol sm = new HtmlTagSimbol( key ) ;
                                out.add( sm ) ;
                                key = null ;
                                value = null ;
                                eq = 0 ;
                            }
                            key = string.substring( s,i ) ;
                            eq = 0 ;
                            s = -1 ;
                        }
                    }
                    else if( eq == 1 ) {
                        if( key == null ) {
                            throw new IOException( "不正な要素内容が存在します[" + string + "]...pos:" + i ) ;
                        }
                        value = string.substring( s,i ) ;
                        HtmlTagKeyValue kv = new HtmlTagKeyValue( key,value ) ;
                        out.add( kv ) ;
                        key = null ;
                        value = null ;
                        eq = 0 ;
                        s = -1 ;
                    }
                }
                else if( c == '=' ) {
                    if( eq == 0 ) {
                        if( s != -1 ) {
                            if( key != null ) {
                                HtmlTagSimbol sm = new HtmlTagSimbol( key ) ;
                                out.add( sm ) ;
                                key = null ;
                                value = null ;
                                eq = 0 ;
                            }
                            key = string.substring( s,i ) ;
                            eq = 1 ;
                            s = -1 ;
                        }
                        else {
                            throw new IOException( "不正な要素内容が存在します[" + string + "]...pos:" + i ) ;
                        }
                    }
                    else {
                        throw new IOException( "不正な要素内容が存在します[" + string + "]...pos:" + i ) ;
                    }
                }
                else if( s == -1 ) {
                    s = i ;
                }
            }
            if( yenFlag ) {
                yenFlag = false ;
                bf = -1 ;
            }
            else {
                bf = ( int )( c & 0x0000ffff ) ;
            }
        }
        if( s != -1 ) {
            if( eq == 0 ) {
                if( s != -1 ) {
                    if( key != null ) {
                        HtmlTagSimbol sm = new HtmlTagSimbol( key ) ;
                        out.add( sm ) ;
                        key = null ;
                        value = null ;
                    }
                    key = string.substring( s ) ;
                    HtmlTagSimbol sm = new HtmlTagSimbol( key ) ;
                    out.add( sm ) ;
                }
            }
            else if( eq == 1 ) {
                if( key == null ) {
                    throw new IOException( "不正な要素内容が存在します[" + string + "]" ) ;
                }
                value = string.substring( s ) ;
                HtmlTagKeyValue kv = new HtmlTagKeyValue( key,value ) ;
                out.add( kv ) ;
            }
        }
    }
    
    private static final boolean startTagPos( int[] out,String s,int pos )
        throws IOException {
        if( pos <= 0 ) {
            pos = 0 ;
        }
        int len = s.length() ;
        int p ;
        while( true ) {
            if( (p = HtmlUtil.indexCote( s,"<",pos )) == -1 ) {
                return false ;
            }
            if( p + 3 < len ) {
                if( s.charAt( p+1 ) == '!' ||
                    s.charAt( p+2 ) == '-' ||
                    s.charAt( p+3 ) == '-' ) {
                    int e = HtmlUtil.indexCote( s,"-->",p+1 ) ;
                    if( e != -1 ) {
                        out[ 0 ] = p ;
                        out[ 1 ] = e+3 ;
                        return true ;
                    }
                    out[ 0 ] = p ;
                    out[ 1 ] = s.length() ;
                    return true ;
                }
            }
            int pp = HtmlUtil.indexCote( s,"<",p+1 ) ;
            int e = HtmlUtil.indexCote( s,">",p+1 ) ;
            if( e == -1 ) {
                return false ;
            }
            else if( pp != -1 && pp < e ) {
                pos = pp ;
            }
            else {
                out[ 0 ] = p ;
                out[ 1 ] = e ;
                return true ;
            }
        }
    }
}

