/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.html;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;

abstract class HtmlUtil {
    private HtmlUtil() {
    }

    protected static final String trim(String string) {
        int s = -1;
        int e = -1;
        int len = string.length();
        s = 0;
        boolean sFlg = false;
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                s = i;
                break;
            }
            sFlg = true;
        }
        e = len - 1;
        boolean eFlg = false;
        for (int i = len - 1; i >= 0; --i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t') {
                e = i;
                break;
            }
            eFlg = true;
        }
        if (sFlg && eFlg) {
            return string.substring(s, e + 1);
        }
        if (sFlg) {
            return string.substring(s);
        }
        if (eFlg) {
            return string.substring(0, e + 1);
        }
        return string;
    }

    protected static final int indexCote(String base, String cc, int off) throws IOException {
        int len = base.length();
        int n = -1;
        char[] ck = cc.toCharArray();
        int cLen = ck.length;
        char bef = '\u0000';
        boolean yenFlag = false;
        for (int i = off; i < len; ++i) {
            char c;
            char c2 = base.charAt(i);
            if (c != '\uffffffff') {
                if (bef != '\\' && c2 == c) {
                    yenFlag = false;
                    c = '\uffffffff';
                } else {
                    yenFlag = c2 == '\\' && bef == '\\';
                }
            } else if (bef != '\\' && (c2 == '\'' || c2 == '\"')) {
                c = c2;
            } else if (c2 == ck[0]) {
                boolean res = true;
                for (int j = 1; j < cLen; ++j) {
                    if (i + j < len && ck[j] == base.charAt(i + j)) continue;
                    res = false;
                    break;
                }
                if (res) {
                    return i;
                }
            }
            if (yenFlag) {
                yenFlag = false;
                bef = '\u0000';
                continue;
            }
            bef = c2;
        }
        return -1;
    }

    protected static final int indexParCote(String base, char st, char ed, int off) throws IOException {
        int len = base.length();
        int par = -1;
        int n = -1;
        int idx = 0;
        int bef = 0;
        boolean yenFlag = false;
        for (int i = off; i < len; ++i) {
            char c;
            char c2 = base.charAt(i);
            if (par != -1 || c != '\uffffffff') {
                if (c != '\uffffffff') {
                    if (bef != 92 && c2 == c) {
                        yenFlag = false;
                        c = '\uffffffff';
                    } else {
                        yenFlag = c2 == '\\' && bef == 92;
                    }
                } else if (par != -1) {
                    if (c2 == ed) {
                        if (--idx <= 0) {
                            return i;
                        }
                    } else if (c2 == st) {
                        ++idx;
                    }
                }
            } else if (c2 == '\'' || c2 == '\"') {
                c = c2;
            } else if (c2 == st) {
                idx = 1;
                par = c2;
            } else if (c2 == ed) {
                return i;
            }
            if (yenFlag) {
                yenFlag = false;
                bef = 0;
                continue;
            }
            bef = c2;
        }
        return -1;
    }

    protected static final String cutEnter(String string) {
        if (string == null || (string = HtmlUtil.trim(string)).length() <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int len = string.length();
        int cote = -1;
        int bef = 0;
        boolean yenFlag = false;
        for (int i = 0; i < len; ++i) {
            int c = string.charAt(i);
            if (cote != -1) {
                if (bef != 92 && c == cote) {
                    yenFlag = false;
                    cote = -1;
                } else {
                    yenFlag = c == 92 && bef == 92;
                }
            } else if (c == 39 || c == 34) {
                cote = c;
            }
            if (c == 13 || c == 10) {
                if (cote != -1) continue;
                buf.append(" ");
                continue;
            }
            buf.append((char)c);
            if (yenFlag) {
                yenFlag = false;
                bef = 0;
                continue;
            }
            bef = c;
        }
        return buf.toString().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static final String getFileByString(String name, String charset) throws Exception {
        char[] tmp = null;
        CharArrayWriter ca = null;
        Reader buf = null;
        String ret = null;
        try {
            int len;
            tmp = new char[8192];
            ca = new CharArrayWriter();
            buf = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), charset));
            while ((len = buf.read(tmp, 0, 8192)) > 0) {
                ca.write(tmp, 0, len);
            }
            ret = ca.toString();
            ca.close();
            ca = null;
            buf.close();
            buf = null;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception t) {}
            }
            if (ca != null) {
                try {
                    ca.close();
                }
                catch (Exception t) {}
            }
            buf = null;
            ca = null;
            tmp = null;
        }
        return ret;
    }

    protected static final void setFileByString(String name, boolean mode, String value, String charset) throws Exception {
        BufferedWriter buf = null;
        if (name == null || value == null) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        try {
            buf = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(name, !mode), charset));
            buf.write(value);
            buf.flush();
            buf.close();
            buf = null;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception t) {}
                buf = null;
            }
        }
    }

    protected static final boolean isFileExists(String name) {
        boolean ret;
        if (name == null || name.length() <= 0) {
            return false;
        }
        try {
            File file = new File(name);
            ret = file.exists() ? (!file.isDirectory() ? file.canRead() : false) : false;
        }
        catch (Exception e) {
            ret = false;
        }
        return ret;
    }
}

