/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.html;

import org.maachang.html.HtmlTagElement;
import org.maachang.html.HtmlUtil;

public class HtmlTagKeyValue
implements HtmlTagElement {
    private String key = "";
    private String value = "";

    public HtmlTagKeyValue() {
        this.key = "";
        this.value = "";
    }

    public HtmlTagKeyValue(String key, String value) {
        this.set(key, value);
    }

    public void clear() {
        this.key = "";
        this.value = "";
    }

    @Override
    public int getType() {
        return 0;
    }

    public void set(String key, String value) {
        if (key == null || (key = HtmlUtil.trim(key)).length() <= 0) {
            throw new IllegalArgumentException("\u30bf\u30b0\u8981\u7d20\u306eKey\u60c5\u5831\u304c\u4e0d\u6b63\u3067\u3059");
        }
        this.key = key.toLowerCase();
        if (value == null || value.length() <= 0) {
            value = "";
        }
        this.value = value;
    }

    @Override
    public String get() {
        return this.key;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void toString(StringBuilder buf) {
        String c = "\"";
        if (this.value.indexOf("'") == -1) {
            c = "'";
        }
        buf.append(this.key).append("=").append(c).append(this.value).append(c);
    }

    public void toSmart(StringBuilder buf) {
        if (this.checkNoCote(this.value)) {
            buf.append(this.key).append("=").append(this.value);
        } else {
            String c = "\"";
            if (this.value.indexOf("'") == -1) {
                c = "'";
            }
            buf.append(this.key).append("=").append(c).append(this.value).append(c);
        }
    }

    private boolean checkNoCote(String value) {
        if (value == null || value.length() <= 0) {
            return true;
        }
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c != '\'' && c != '\"' && c != ' ' && c != '\t' && c != '\r' && c != '\n') continue;
            return false;
        }
        return true;
    }
}

