/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.maachang.html.Html;
import org.maachang.html.HtmlAnalysis;
import org.maachang.html.HtmlElement;
import org.maachang.html.HtmlTagElement;
import org.maachang.html.HtmlTagKeyValue;
import org.maachang.html.HtmlTagSimbol;
import org.maachang.html.HtmlUtil;
import org.maachang.html.StackObject;

public class HtmlTag
implements HtmlElement {
    private String tagName = null;
    private List<HtmlTagElement> elements = null;
    private boolean endFlag = false;
    private boolean startEndFlag = false;
    private String id = null;
    private int listNo = -1;
    private Html parent = null;

    private HtmlTag() {
    }

    public HtmlTag(boolean startEndFlag, boolean endFlag, String tagName) throws IOException {
        this(startEndFlag, endFlag, tagName, null);
    }

    public HtmlTag(boolean startEndFlag, boolean endFlag, String tagName, List<HtmlTagElement> elements) throws IOException {
        if (tagName == null || (tagName = HtmlUtil.trim(tagName)).length() < 0) {
            throw new IOException("\u4e0d\u6b63\u306a\u30bf\u30b0\u540d\u304c\u8a2d\u5b9a\u3055\u308c\u307e\u3057\u305f");
        }
        if (endFlag) {
            startEndFlag = false;
        }
        this.tagName = tagName.toLowerCase();
        this.endFlag = endFlag;
        this.startEndFlag = startEndFlag;
        if (!endFlag) {
            this.elements = elements;
            this.checkId(elements);
        }
    }

    public void add(String simbol) {
        if (!this.endFlag) {
            if (simbol == null || (simbol = HtmlUtil.trim(simbol)).length() <= 0) {
                return;
            }
            this.add(new HtmlTagSimbol(simbol));
        }
    }

    public void add(String key, String value) {
        if (!this.endFlag) {
            if (key == null || (key = HtmlUtil.trim(key)).length() <= 0) {
                return;
            }
            this.add(new HtmlTagKeyValue(key, value));
        }
    }

    public void add(HtmlTagElement element) {
        if (!this.endFlag) {
            if (element == null) {
                return;
            }
            if (this.elements == null) {
                this.elements = new ArrayList<HtmlTagElement>();
            }
            if (element instanceof HtmlTagKeyValue) {
                String tagId;
                HtmlTagKeyValue kv = (HtmlTagKeyValue)element;
                if ("id".equals(kv.getKey()) && (tagId = kv.getValue()) != null && tagId.length() > 0) {
                    this.id = tagId;
                }
                this.addTo(kv);
            } else {
                this.elements.add(element);
            }
        }
    }

    private void addTo(HtmlTagKeyValue tkv) {
        int len = this.elements.size();
        String key = tkv.getKey();
        for (int i = 0; i < len; ++i) {
            HtmlTagKeyValue kv;
            HtmlTagElement em = this.elements.get(i);
            if (!(em instanceof HtmlTagKeyValue) || !tkv.equals((kv = (HtmlTagKeyValue)em).getKey())) continue;
            if (key.equals("style") || key.startsWith("on")) {
                String v = kv.getValue();
                kv.set(key, v + ";" + tkv.getValue());
            } else {
                kv.set(key, tkv.getValue());
            }
            return;
        }
        this.elements.add(tkv);
    }

    public HtmlTagElement get(int no) {
        if (!this.endFlag) {
            if (this.elements == null || no <= -1 || no >= this.elements.size()) {
                return null;
            }
            return this.elements.get(no);
        }
        return null;
    }

    public HtmlTagElement get(String name) {
        return this.get(name, 0);
    }

    public HtmlTagElement get(String name, int off) {
        if (!this.endFlag) {
            return this.get(this.search(name, off));
        }
        return null;
    }

    public HtmlTagElement remove(int no) {
        if (!this.endFlag) {
            if (this.elements == null || no <= -1 || no >= this.elements.size()) {
                return null;
            }
            return this.elements.remove(no);
        }
        return null;
    }

    public HtmlTagElement remove(String name) {
        return this.remove(name, 0);
    }

    public HtmlTagElement remove(String name, int off) {
        if (!this.endFlag) {
            return this.remove(this.search(name, off));
        }
        return null;
    }

    public void addHTML(String html) throws IOException {
        if (html == null || (html = html.trim()).length() <= 0) {
            return;
        }
        if (this.listNo >= 0 && this.parent != null) {
            HtmlTag t = this.parent.getEndTag(this);
            if (t == null) {
                return;
            }
            this.parent.insert(t.getListNo(), html);
        }
    }

    public void innerHTML(String html) throws IOException {
        if (html == null || (html = html.trim()).length() <= 0) {
            return;
        }
        if (this.listNo >= 0 && this.parent != null) {
            HtmlTag t = this.parent.getEndTag(this);
            if (t == null) {
                return;
            }
            this.parent.remove(this);
            this.parent.insert(this.listNo + 1, html);
        }
    }

    public String innerHTML() {
        if (this.listNo >= 0 && this.parent != null) {
            HtmlTag t = this.parent.getEndTag(this);
            if (t == null) {
                return "";
            }
            StringBuilder buf = new StringBuilder();
            int len = t.getListNo() - this.listNo - 1;
            int off = this.listNo + 1;
            for (int i = 0; i < len; ++i) {
                this.parent.get(i + off).toString(buf);
            }
            return buf.toString();
        }
        return "";
    }

    public String getPath() {
        if (this.listNo >= 0 && this.parent != null) {
            Object o;
            int len = this.listNo;
            StackObject lst = new StackObject();
            for (int i = 0; i < len; ++i) {
                HtmlElement em = this.parent.get(i);
                if (!(em instanceof HtmlTag)) continue;
                HtmlTag tg = (HtmlTag)em;
                if (tg.isEndTag()) {
                    HtmlTag st = (HtmlTag)lst.peek();
                    if (this.parent.getEndTag(st) != tg) continue;
                    lst.pop();
                    continue;
                }
                if (this.parent.getEndTag(tg) == null) continue;
                lst.push(tg);
            }
            ArrayList<HtmlTag> ast = new ArrayList<HtmlTag>();
            while ((o = lst.pop()) != null) {
                ast.add((HtmlTag)o);
            }
            lst = null;
            if (ast.size() <= 0) {
                return "/" + this.tagName;
            }
            StringBuilder buf = new StringBuilder();
            len = ast.size();
            buf.append("/");
            for (int i = len - 1; i >= 0; --i) {
                buf.append(((HtmlTag)ast.get(i)).getName()).append("/");
            }
            buf.append(this.tagName);
            return buf.toString();
        }
        return "";
    }

    public int size() {
        if (!this.endFlag) {
            return this.elements == null ? 0 : this.elements.size();
        }
        return 0;
    }

    public String getName() {
        return this.tagName;
    }

    public String getId() {
        return this.id;
    }

    public boolean isEndTag() {
        return this.endFlag;
    }

    public boolean isStartEnd() {
        return this.startEndFlag;
    }

    @Override
    public int getListNo() {
        return this.listNo;
    }

    @Override
    public void setListNo(int no) {
        this.listNo = no;
    }

    protected void setParent(Html parent) {
        this.parent = parent;
    }

    protected Html getParent() {
        return this.parent;
    }

    @Override
    public void toString(StringBuilder buf) {
        buf.append("<");
        if (this.endFlag) {
            buf.append("/").append(this.tagName).append(">");
        } else {
            buf.append(this.tagName);
            int len = this.elements.size();
            for (int i = 0; i < len; ++i) {
                buf.append(" ");
                this.elements.get(i).toString(buf);
            }
            if (this.startEndFlag) {
                buf.append(" / ");
            }
            buf.append(">");
        }
    }

    public void toSmart(StringBuilder buf) {
        buf.append("<");
        if (this.endFlag) {
            buf.append("/").append(this.tagName).append(">");
        } else {
            buf.append(this.tagName);
            int len = this.elements.size();
            for (int i = 0; i < len; ++i) {
                buf.append(" ");
                HtmlTagElement em = this.elements.get(i);
                if (em instanceof HtmlTagKeyValue) {
                    ((HtmlTagKeyValue)em).toSmart(buf);
                    continue;
                }
                em.toString(buf);
            }
            if (this.startEndFlag) {
                buf.append(" / ");
            }
            buf.append(">");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.toString(buf);
        return buf.toString();
    }

    public static final HtmlTag convert(String string) throws IOException {
        if (string == null || (string = HtmlUtil.trim(string)).length() <= 0) {
            throw new IOException("\u4e0d\u6b63\u306a\u30bf\u30b0\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u3059");
        }
        if (string.startsWith("<") && string.endsWith(">")) {
            string = string.substring(1, string.length() - 1);
        }
        string = HtmlUtil.trim(string);
        int[] oPos = new int[]{0};
        String tag = HtmlAnalysis.getTagName(oPos, string);
        boolean end = false;
        boolean startEnd = false;
        int p = string.indexOf("/");
        if (p != -1 && p < oPos[0]) {
            end = true;
        }
        if (string.endsWith("/")) {
            if (end) {
                throw new IOException("\u4e0d\u6b63\u306a\u30bf\u30b0\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u3059");
            }
            startEnd = true;
            string = string.substring(0, string.length() - 1);
        }
        if (oPos[0] > 0) {
            string = string.substring(oPos[0]);
        }
        oPos = null;
        ArrayList<HtmlTagElement> em = new ArrayList<HtmlTagElement>();
        HtmlAnalysis.cutElement(em, string);
        return new HtmlTag(startEnd, end, tag, em);
    }

    private void checkId(List<HtmlTagElement> elements) {
        if (elements != null && elements.size() > 0) {
            int len = elements.size();
            for (int i = 0; i < len; ++i) {
                HtmlTagKeyValue kv;
                HtmlTagElement element = elements.get(i);
                if (!(element instanceof HtmlTagKeyValue) || !"id".equals((kv = (HtmlTagKeyValue)element).getKey())) continue;
                this.id = kv.getValue();
            }
        }
    }

    private int search(String key, int off) {
        if (this.elements == null || key == null || (key = HtmlUtil.trim(key)).length() <= 0) {
            return -1;
        }
        if (off >= this.elements.size()) {
            return -1;
        }
        if (off <= 0) {
            off = 0;
        }
        key = key.toLowerCase();
        int len = this.elements.size();
        for (int i = off; i < len; ++i) {
            if (!key.equals(this.elements.get(i).get())) continue;
            return i;
        }
        return -1;
    }
}

