/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.html;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.maachang.html.Html;
import org.maachang.html.HtmlComment;
import org.maachang.html.HtmlElement;
import org.maachang.html.HtmlElementList;
import org.maachang.html.HtmlTag;
import org.maachang.html.HtmlTagElement;
import org.maachang.html.HtmlTagKeyValue;
import org.maachang.html.HtmlTagSimbol;
import org.maachang.html.HtmlUtil;
import org.maachang.html.HtmlView;

abstract class HtmlAnalysis {
    private HtmlAnalysis() {
    }

    protected static final void analysis(int no, Html parent, Map<String, HtmlElement> tagId, HtmlElementList out, String string) throws IOException {
        String s;
        int b;
        int[] o;
        if (no <= -1) {
            no = -1;
        }
        if (!HtmlAnalysis.startTagPos(o = new int[2], string, b = 0)) {
            if ((string = string.trim()).length() > 0) {
                if (no <= -1) {
                    out.add(new HtmlView(string));
                } else {
                    out.insert(no, new HtmlView(string));
                    ++no;
                }
            }
            return;
        }
        int p = o[0];
        int e = o[1];
        if (p > 0 && (s = string.substring(b, p).trim()).length() > 0) {
            if (no <= -1) {
                out.add(new HtmlView(s));
            } else {
                out.insert(no, new HtmlView(s));
                ++no;
            }
        }
        while (true) {
            String s2;
            String t;
            if ((t = string.substring(p, e + 1)).charAt(1) == '!' && t.charAt(2) == '-' && t.charAt(3) == '-') {
                if ((t = t.substring("<!--".length(), t.length() - "-->".length()).trim()).length() > 0) {
                    if (no <= -1) {
                        out.add(new HtmlComment(t));
                    } else {
                        out.insert(no, new HtmlComment(t));
                        ++no;
                    }
                }
            } else {
                s2 = t.substring(1, t.length() - 1).trim();
                if (s2.length() <= 0 || s2.toLowerCase().startsWith("!doctype")) {
                    if (no <= -1) {
                        out.add(new HtmlView(t));
                    } else {
                        out.insert(no, new HtmlView(t));
                        ++no;
                    }
                } else {
                    t = HtmlUtil.cutEnter(t);
                    HtmlTag tg = HtmlTag.convert(t);
                    if (no <= -1) {
                        out.add(tg);
                    } else {
                        out.insert(no, tg);
                        ++no;
                    }
                    if (tg.getId() != null) {
                        tagId.put(tg.getId(), tg);
                    }
                    tg.setParent(parent);
                }
            }
            if (!HtmlAnalysis.startTagPos(o, string, b = e + 1)) {
                s2 = string.substring(b).trim();
                if (s2.length() > 0) {
                    if (no <= -1) {
                        out.add(new HtmlView(s2));
                    } else {
                        out.insert(no, new HtmlView(s2));
                        ++no;
                    }
                }
                return;
            }
            p = o[0];
            e = o[1];
            if (b == p || (s2 = string.substring(b, p).trim()).length() <= 0) continue;
            if (no <= -1) {
                out.add(new HtmlView(s2));
                continue;
            }
            out.insert(no, new HtmlView(s2));
            ++no;
        }
    }

    protected static final String getTagName(int[] out, String string) throws IOException {
        int s = -1;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ' || c == '\u3000' || c == '\r' || c == '\n' || c == '\t' || c == '/') continue;
            s = i;
            break;
        }
        if (s == -1) {
            throw new IOException("\u4e0d\u6b63\u306a\u30bf\u30b0\u6761\u4ef6\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
        }
        int p = -1;
        for (int i = s; i < len; ++i) {
            char c = string.charAt(i);
            if (c != ' ' && c != '\u3000' && c != '\r' && c != '\n' && c != '\t' && c != '>') continue;
            p = i;
            break;
        }
        if (p == -1) {
            out[0] = string.length();
            return HtmlUtil.trim(string.substring(s).toLowerCase());
        }
        out[0] = p;
        return HtmlUtil.trim(string.substring(s, p).toLowerCase());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static final void cutElement(List<HtmlTagElement> out, String string) throws IOException {
        if (string == null || (string = HtmlUtil.trim(string)).length() <= 0) {
            return;
        }
        int len = string.length();
        int cote = -1;
        int s = -1;
        int bf = -1;
        boolean eq = false;
        String key = null;
        String value = null;
        boolean yenFlag = false;
        for (int i = 0; i < len; ++i) {
            HtmlTagKeyValue kv;
            int c = string.charAt(i);
            if (cote != -1) {
                if (c == cote && bf != 92) {
                    yenFlag = false;
                    cote = -1;
                    if (key == null) throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                    value = string.substring(s + 1, i);
                    kv = new HtmlTagKeyValue(key, value);
                    out.add(kv);
                    key = null;
                    value = null;
                    eq = false;
                    s = -1;
                } else {
                    yenFlag = c == 92 && bf == 92;
                }
            } else {
                HtmlTagSimbol sm;
                if (c == 39 || c == 34) {
                    if (s != -1) {
                        throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                    }
                    if (key == null) {
                        throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                    }
                    if (bf == 92) {
                        throw new IOException("\u4e0d\u6b63\u306a\u30b3\u30fc\u30c6\u30fc\u30b7\u30e7\u30f3\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                    }
                    cote = c;
                    s = i;
                    continue;
                }
                if (c == 13 || c == 10 || c == 32 || c == 12288 || c == 9) {
                    if (!eq) {
                        if (s != -1) {
                            if (key != null) {
                                sm = new HtmlTagSimbol(key);
                                out.add(sm);
                                key = null;
                                value = null;
                                eq = false;
                            }
                            key = string.substring(s, i);
                            eq = false;
                            s = -1;
                        }
                    } else if (eq) {
                        if (key == null) {
                            throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                        }
                        value = string.substring(s, i);
                        kv = new HtmlTagKeyValue(key, value);
                        out.add(kv);
                        key = null;
                        value = null;
                        eq = false;
                        s = -1;
                    }
                } else if (c == 61) {
                    if (eq) throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                    if (s == -1) throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]...pos:" + i);
                    if (key != null) {
                        sm = new HtmlTagSimbol(key);
                        out.add(sm);
                        key = null;
                        value = null;
                        eq = false;
                    }
                    key = string.substring(s, i);
                    eq = true;
                    s = -1;
                } else if (s == -1) {
                    s = i;
                }
            }
            if (yenFlag) {
                yenFlag = false;
                bf = -1;
                continue;
            }
            bf = c & 0xFFFF;
        }
        if (s == -1) return;
        if (!eq) {
            if (s == -1) return;
            if (key != null) {
                HtmlTagSimbol sm = new HtmlTagSimbol(key);
                out.add(sm);
                key = null;
                value = null;
            }
            key = string.substring(s);
            HtmlTagSimbol sm = new HtmlTagSimbol(key);
            out.add(sm);
            return;
        } else {
            if (!eq) return;
            if (key == null) {
                throw new IOException("\u4e0d\u6b63\u306a\u8981\u7d20\u5185\u5bb9\u304c\u5b58\u5728\u3057\u307e\u3059[" + string + "]");
            }
            value = string.substring(s);
            HtmlTagKeyValue kv = new HtmlTagKeyValue(key, value);
            out.add(kv);
        }
    }

    private static final boolean startTagPos(int[] out, String s, int pos) throws IOException {
        int e;
        int p;
        if (pos <= 0) {
            pos = 0;
        }
        int len = s.length();
        while (true) {
            if ((p = HtmlUtil.indexCote(s, "<", pos)) == -1) {
                return false;
            }
            if (p + 3 < len && (s.charAt(p + 1) == '!' || s.charAt(p + 2) == '-' || s.charAt(p + 3) == '-')) {
                int e2 = HtmlUtil.indexCote(s, "-->", p + 1);
                if (e2 != -1) {
                    out[0] = p;
                    out[1] = e2 + 3;
                    return true;
                }
                out[0] = p;
                out[1] = s.length();
                return true;
            }
            int pp = HtmlUtil.indexCote(s, "<", p + 1);
            e = HtmlUtil.indexCote(s, ">", p + 1);
            if (e == -1) {
                return false;
            }
            if (pp == -1 || pp >= e) break;
            pos = pp;
        }
        out[0] = p;
        out[1] = e;
        return true;
    }
}

