/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.html;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.maachang.html.HtmlAnalysis;
import org.maachang.html.HtmlComment;
import org.maachang.html.HtmlElement;
import org.maachang.html.HtmlElementList;
import org.maachang.html.HtmlTag;
import org.maachang.html.HtmlUtil;
import org.maachang.html.HtmlView;

public class Html {
    private final Map<String, HtmlElement> tagId = new HashMap<String, HtmlElement>();
    private final HtmlElementList list = new HtmlElementList();

    public Html() {
    }

    public Html(String html) throws IOException {
        this.create(html);
    }

    public void create() {
        this.clear();
    }

    public void create(String html) throws IOException {
        if (html == null || (html = html.trim()).length() <= 0) {
            this.create();
            return;
        }
        this.clear();
        HtmlAnalysis.analysis(-1, this, this.tagId, this.list, html);
    }

    public void clear() {
        this.list.clear();
        this.tagId.clear();
    }

    public void add(HtmlElement element) {
        if (element == null) {
            return;
        }
        this.list.add(element);
        this.addTag(element);
    }

    public void add(String html) throws IOException {
        if (html == null || (html = html.trim()).length() <= 0) {
            return;
        }
        HtmlAnalysis.analysis(-1, this, this.tagId, this.list, html);
    }

    public void set(int no, HtmlElement element) {
        if (no <= -1 || no >= this.list.size() || element == null) {
            return;
        }
        HtmlElement em = this.list.set(no, element);
        this.addTag(element);
        this.removeTag(em);
    }

    public void set(HtmlTag tag, HtmlElement element) {
        if (tag == null) {
            return;
        }
        this.set(tag.getListNo(), element);
    }

    public void set(int no, String html) throws IOException {
        if (no <= -1 || no >= this.list.size() || html == null || (html = html.trim()).length() <= 0) {
            this.remove(no);
            return;
        }
        this.remove(no);
        HtmlAnalysis.analysis(no, this, this.tagId, this.list, html);
    }

    public void set(HtmlTag tag, String html) throws IOException {
        if (tag == null) {
            return;
        }
        this.set(tag.getListNo(), html);
    }

    public void insert(int no, HtmlElement element) {
        if (no <= -1 || no >= this.list.size() || element == null) {
            return;
        }
        if (++no >= this.list.size()) {
            this.add(element);
        } else {
            this.list.insert(no, element);
            this.addTag(element);
        }
    }

    public void insert(HtmlTag tag, HtmlElement element) {
        if (tag == null) {
            return;
        }
        this.insert(tag.getListNo(), element);
    }

    public void insert(int no, String html) throws IOException {
        if (no <= -1 || no >= this.list.size() || html == null || (html = html.trim()).length() <= 0) {
            return;
        }
        if (++no >= this.list.size()) {
            this.add(html);
        } else {
            HtmlAnalysis.analysis(no, this, this.tagId, this.list, html);
        }
    }

    public void insert(HtmlTag tag, String html) throws IOException {
        if (tag == null) {
            return;
        }
        this.insert(tag.getListNo(), html);
    }

    public void remove(int no) {
        if (no <= -1 || no >= this.list.size()) {
            return;
        }
        HtmlElement em = this.list.remove(no);
        this.removeTag(em);
    }

    public void remove(HtmlTag tag) {
        HtmlTag t = this.getEndTag(tag);
        if (t == null && t.getListNo() <= -1) {
            return;
        }
        int len = t.getListNo() - tag.getListNo() - 1;
        int off = tag.getListNo() + 1;
        for (int i = 0; i < len; ++i) {
            this.remove(off);
        }
    }

    public HtmlElement get(int no) {
        if (no <= -1 || no >= this.list.size()) {
            return null;
        }
        return this.list.get(no);
    }

    public HtmlTag getElementById(String id) {
        if (id == null || id.length() <= 0) {
            return null;
        }
        HtmlElement em = this.tagId.get(id);
        if (em == null || !(em instanceof HtmlTag)) {
            return null;
        }
        return (HtmlTag)em;
    }

    public HtmlTag getElementsByTagName(String tagName) {
        int n = this.searchTag(tagName, 0);
        if (n <= -1) {
            return null;
        }
        return (HtmlTag)this.list.get(n);
    }

    public HtmlTag getElementsByTagName(String tagName, int off) {
        int n = this.searchTag(tagName, off);
        if (n <= -1) {
            return null;
        }
        return (HtmlTag)this.list.get(n);
    }

    public HtmlTag getElementsByTagName(HtmlTag tag) {
        if (tag == null) {
            return null;
        }
        int off = tag.getListNo();
        String tagName = tag.getName();
        off = off <= -1 ? 0 : ++off;
        int n = this.searchTag(tagName, off);
        if (n <= -1) {
            return null;
        }
        return (HtmlTag)this.list.get(n);
    }

    public HtmlTag getEndTag(HtmlTag tag) {
        if (tag == null) {
            return null;
        }
        int off = tag.getListNo();
        if (off <= -1) {
            return null;
        }
        int n = this.searchEndTag(off);
        if (n <= -1) {
            return null;
        }
        return (HtmlTag)this.list.get(n);
    }

    public int size() {
        return this.list.size();
    }

    public List<String> getIds() {
        int len;
        if (this.tagId.size() <= 0) {
            return new ArrayList<String>();
        }
        Object[] o = this.tagId.keySet().toArray();
        if (o == null || (len = o.length) <= 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            ret.add((String)o[i]);
        }
        Object[] lst = ret.toArray();
        ret.clear();
        Arrays.sort(lst);
        len = lst.length;
        for (int i = 0; i < len; ++i) {
            ret.add((String)lst[i]);
        }
        return ret;
    }

    public List<String> getIds(String head) {
        int len;
        if (head == null || (head = head.trim()).length() <= 0) {
            return this.getIds();
        }
        if (this.tagId.size() <= 0) {
            return new ArrayList<String>();
        }
        Object[] o = this.tagId.keySet().toArray();
        if (o == null || (len = o.length) <= 0) {
            return new ArrayList<String>();
        }
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < len; ++i) {
            String s = (String)o[i];
            if (!s.startsWith(head)) continue;
            ret.add(s);
        }
        Object[] lst = ret.toArray();
        ret.clear();
        Arrays.sort(lst);
        len = lst.length;
        for (int i = 0; i < len; ++i) {
            ret.add((String)lst[i]);
        }
        return ret;
    }

    public Iterator iterator() {
        return this.tagId.keySet().iterator();
    }

    public String toString() {
        int len = this.list.size();
        if (len <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            if (i != 0) {
                buf.append("\n");
            }
            this.list.get(i).toString(buf);
        }
        return buf.toString();
    }

    public String toSmart() {
        int len = this.list.size();
        if (len <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        int type = 0;
        int cnt = 0;
        for (int i = 0; i < len; ++i) {
            HtmlTag tg;
            HtmlElement em = this.list.get(i);
            if (type == 0) {
                if (em instanceof HtmlView) {
                    this.smart(buf, (HtmlView)em);
                    continue;
                }
                if (!(em instanceof HtmlTag)) continue;
                ((HtmlTag)em).toSmart(buf);
                tg = (HtmlTag)em;
                if (tg.isEndTag() || tg.isStartEnd()) continue;
                String name = tg.getName();
                if ("pre".equals(name)) {
                    type = 1;
                    cnt = 1;
                    continue;
                }
                if ("textarea".equals(name)) {
                    type = 2;
                    cnt = 1;
                    continue;
                }
                if ("script".equals(name)) {
                    type = 10;
                    cnt = 1;
                    continue;
                }
                if (!"style".equals(name)) continue;
                type = 11;
                cnt = 1;
                continue;
            }
            if (em instanceof HtmlTag) {
                ((HtmlTag)em).toSmart(buf);
                tg = (HtmlTag)em;
                int ap = 0;
                if (!tg.isEndTag() && !tg.isStartEnd()) {
                    ap = 1;
                } else if (tg.isEndTag()) {
                    ap = -1;
                }
                boolean flg = false;
                String name = tg.getName();
                if (type == 1 && "pre".equals(name)) {
                    cnt += ap;
                    flg = true;
                } else if (type == 2 && "textarea".equals(name)) {
                    cnt += ap;
                    flg = true;
                } else if (type == 10 && "script".equals(name)) {
                    cnt += ap;
                    flg = true;
                } else if (type == 11 && "style".equals(name)) {
                    cnt += ap;
                    flg = true;
                }
                if (!flg || cnt > 0) continue;
                type = 0;
                continue;
            }
            if (!(em instanceof HtmlView) && (!(em instanceof HtmlComment) || type < 10)) continue;
            em.toString(buf);
        }
        return buf.toString();
    }

    public String toTidy() {
        return this.toTidy(4);
    }

    public String toTidy(int indent) {
        if (indent <= 0) {
            return this.toString();
        }
        int len = this.list.size();
        if (len <= 0) {
            return "";
        }
        int spaceLen = 0;
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            HtmlElement em;
            int addLen = 0;
            if (i != 0) {
                buf.append("\n");
            }
            if ((em = this.list.get(i)) instanceof HtmlTag) {
                HtmlTag tg = (HtmlTag)em;
                if (tg.isEndTag()) {
                    if ((spaceLen -= indent) <= 0) {
                        spaceLen = 0;
                    }
                } else if (!tg.isStartEnd() && this.getEndTag(tg) != null) {
                    addLen = indent;
                }
            }
            for (int j = 0; j < spaceLen; ++j) {
                buf.append(" ");
            }
            spaceLen += addLen;
            em.toString(buf);
        }
        return buf.toString();
    }

    public int searchTag(String tagName, int off) {
        if (tagName == null || (tagName = HtmlUtil.trim(tagName)).length() <= 0) {
            return -1;
        }
        int len = this.list.size();
        if (off >= len) {
            return -1;
        }
        if (off <= 0) {
            off = 0;
        }
        tagName = tagName.toLowerCase();
        for (int i = off; i < len; ++i) {
            HtmlElement e = this.list.get(i);
            if (!(e instanceof HtmlTag) || !tagName.equals(((HtmlTag)e).getName())) continue;
            return i;
        }
        return -1;
    }

    public int searchId(String id) {
        if (id == null || id.length() <= 0) {
            return -1;
        }
        HtmlElement em = this.tagId.get(id);
        if (em == null) {
            return -1;
        }
        return em.getListNo();
    }

    public int searchEndTag(int no) {
        HtmlTag tg;
        int len = this.list.size();
        if (no >= len) {
            return -1;
        }
        if (no <= 0) {
            no = 0;
        }
        String target = null;
        HtmlElement e = this.list.get(no);
        if (e instanceof HtmlTag) {
            tg = (HtmlTag)e;
            if (tg.isEndTag() || tg.isStartEnd()) {
                return -1;
            }
        } else {
            return -1;
        }
        target = tg.getName();
        int tNo = 1;
        for (int i = no + 1; i < len; ++i) {
            HtmlTag tg2;
            e = this.list.get(i);
            if (!(e instanceof HtmlTag) || !target.equals((tg2 = (HtmlTag)e).getName()) || tg2.isStartEnd()) continue;
            if (tg2.isEndTag()) {
                if (--tNo > 0) continue;
                return i;
            }
            ++tNo;
        }
        return -1;
    }

    private void addTag(HtmlElement em) {
        if (em != null && em instanceof HtmlTag) {
            HtmlTag tg = (HtmlTag)em;
            if (tg.getId() != null) {
                this.tagId.put(tg.getId(), tg);
            }
            tg.setParent(this);
        }
    }

    private void removeTag(HtmlElement em) {
        if (em != null && em instanceof HtmlTag) {
            HtmlTag tg = (HtmlTag)em;
            if (tg.getId() != null) {
                this.tagId.remove(tg.getId());
            }
            tg.setParent(null);
        }
    }

    private void smart(StringBuilder buf, HtmlView view) {
        String s = view.get();
        if (s == null || s.length() <= 0) {
            return;
        }
        if (s.startsWith("<") && s.endsWith(">")) {
            buf.append(s);
            return;
        }
        int len = s.length();
        char b = '\u0000';
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\r' || c == '\n' || c == '\t' || c == ' ' && b == c) {
                b = c;
                continue;
            }
            buf.append(c);
            b = c;
        }
    }
}

