package org.maachang.luxio.test ;

import org.maachang.luxio.LuxIoImpl;
import org.maachang.luxio.LuxOp;

/**
 * test.
 *  
 * @version 2008/12/05
 * @author  masahito suzuki
 * @since   Luxio 0.1.0
 */
public class Test {
    
    public static final void main( String[] args ) throws Exception {
        int len = 1000000 ;
        LuxIoImpl lux = null ;
        LuxOp op = null ;
        try {
            lux = new LuxIoImpl( "test" ) ;
            op = new LuxOp( false,lux ) ;
            String[] keys = new String[len] ;
            System.out.println( "**** init ****" ) ;
            long time = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                String k = new StringBuilder().
                    append( "00000000".substring( String.valueOf( i ).length() ) ).
                    append( String.valueOf( i ) ).toString() ;
                keys[ i ] = k ;
            }
            time = System.currentTimeMillis() - time ;
            //System.out.println( "init:" + time + "msec" ) ;
            System.out.println( "**** start ****" ) ;
            time = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                op.put( keys[ i ],i ) ;
            }
            time = System.currentTimeMillis() - time ;
            System.out.println( "write:" + time + "msec" ) ;
            
            time = System.currentTimeMillis() ;
            for( int i = 0 ; i < len ; i ++ ) {
                //int x = op.getInteger( keys[ i ] ) ;
                //System.out.println( x ) ;
            	op.getInteger( keys[ i ] ) ;
            }
            op.commit() ;
            op.clear() ;
            time = System.currentTimeMillis() - time ;
            System.out.println( "read:" + time + "msec" ) ;
        } finally {
            if( lux != null ) {
                lux.destroy() ;
            }
            lux = null ;
        }
    }
}
