package org.maachang.luxio ;

/**
 * Lux&nbsp;IOを操作するインターフェイス定義.
 *
 * @version 2008/12/05
 * @author  masahito suzuki
 * @since   Lux IO 0.1.0
 */
public interface LuxIo {
    
    /**
     * オブジェクトが有効かチェック.
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() ;
    
    /**
     * 情報をセット.
     * @param key 対象のキーを設定します.
     * @param value 対象の要素を設定します.
     * @exception Exception 例外.
     */
    public void put( String key,byte[] value ) throws Exception ;
    
    /**
     * 情報を取得.
     * @param key 対象のキーを設定します.
     * @return byte[] 対象の要素が返されます.
     * @exception Exception 例外.
     */
    public byte[] get( String key ) throws Exception ;
    
    /**
     * 情報を削除.
     * @param key 対象のキーを設定します.
     * @exception Exception 例外.
     */
    public void remove( String key ) throws Exception ;
    
}
