#ifdef _WIN32
#include <windows.h>
#include <io.h>
#include <limits.h>

#include "flock.h"

int win32_flock(int fd, int operation) {
  HANDLE h = (HANDLE) _get_osfhandle(fd);
  BOOL r = 0;

  switch(operation) {
  case LOCK_SH:
    r = LockFileEx(h, 0, 0, ULONG_MAX, ULONG_MAX, 0);
    break;

  case LOCK_EX:
    r = LockFileEx(h, LOCKFILE_EXCLUSIVE_LOCK, 0, ULONG_MAX, ULONG_MAX, 0);
    break;

  case LOCK_UN:
    r = UnlockFileEx(h, 0, ULONG_MAX, ULONG_MAX, 0);
    break;
  }

  return (r != 0) ? 0 : -1;
}
#endif
