/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.luxio;

import java.util.Locale;

class Os {
    private static final String OS_NAME_UNIX = "UNIX";
    private static final String OS_NAME_DOS = "DOS";
    private static final String OS_NAME_WINNT = "WINDOWS NT";
    private static final String OS_NAME_WIN9X = "WINDOWS 9X";
    private static final String OS_NAME_OS_2 = "OS/2";
    private static final String OS_NAME_MACINTOSH = "MACINTOSH";
    private static final String OS_NAME_MAC_OS_X = "MAC-OS-X";
    private static final String OS_NAME_NETWARE = "NETWARE";
    private static final String OS_NAME_TANDEM = "TANDEM";
    private static final String OS_NAME_Z_OS = "Z/OS";
    private static final String OS_NAME_OS_400 = "OS/400";
    private static final String OS_NAME_OPENVMS = "OPENVMS";
    private static final String OS_NAME_UNKNOWN = "UNKNOWN";
    public static final int OS_UNIX = 1;
    public static final int OS_DOS = 16;
    public static final int OS_WINNT = 33;
    public static final int OS_WIN9X = 34;
    public static final int OS_OS_2 = 49;
    public static final int OS_MACINTOSH = 65;
    public static final int OS_MAC_OS_X = 66;
    public static final int OS_NETWARE = 257;
    public static final int OS_TANDEM = 273;
    public static final int OS_Z_OS = 289;
    public static final int OS_OS_400 = 305;
    public static final int OS_OPENVMS = 321;
    public static final int OS_UNKNOWN = 65535;
    private final int osType = Os.getVmOS();
    private static final Os SNGL = new Os();

    private Os() {
    }

    public static final Os getInstance() {
        return SNGL;
    }

    public final int getOS() {
        return this.osType;
    }

    public final String getName(int type) {
        String ret = null;
        switch (type) {
            case 1: {
                ret = OS_NAME_UNIX;
                break;
            }
            case 16: {
                ret = OS_NAME_DOS;
                break;
            }
            case 33: {
                ret = OS_NAME_WINNT;
                break;
            }
            case 34: {
                ret = OS_NAME_WIN9X;
                break;
            }
            case 49: {
                ret = OS_NAME_OS_2;
                break;
            }
            case 65: {
                ret = OS_NAME_MACINTOSH;
                break;
            }
            case 66: {
                ret = OS_NAME_MAC_OS_X;
                break;
            }
            case 257: {
                ret = OS_NAME_NETWARE;
                break;
            }
            case 273: {
                ret = OS_NAME_TANDEM;
                break;
            }
            case 289: {
                ret = OS_NAME_Z_OS;
                break;
            }
            case 305: {
                ret = OS_NAME_OS_400;
                break;
            }
            case 321: {
                ret = OS_NAME_OPENVMS;
                break;
            }
            default: {
                ret = OS_NAME_UNKNOWN;
            }
        }
        return ret;
    }

    public final boolean isOs(int type) {
        return type == this.osType;
    }

    private static final int getVmOS() {
        int ret = 65535;
        if (Os.checkOS("windows")) {
            ret = 33;
        } else if (Os.checkOS("os2")) {
            ret = 49;
        } else if (Os.checkOS("netware")) {
            ret = 257;
        } else if (Os.checkOS("dos")) {
            ret = 16;
        } else if (Os.checkOS("mac")) {
            ret = 65;
        } else if (Os.checkOS("macX")) {
            ret = 66;
        } else if (Os.checkOS("tandem")) {
            ret = 273;
        } else if (Os.checkOS("unix")) {
            ret = 1;
        } else if (Os.checkOS("win9x")) {
            ret = 34;
        } else if (Os.checkOS("z/os")) {
            ret = 289;
        } else if (Os.checkOS("os/400")) {
            ret = 305;
        } else if (Os.checkOS("openvms")) {
            ret = 321;
        }
        return ret;
    }

    private static final boolean checkOS(String name) {
        boolean ret = false;
        String path_sp = null;
        String os_name = null;
        path_sp = System.getProperty("path.separator");
        os_name = System.getProperty("os.name").toLowerCase(Locale.US);
        if (name != null) {
            if (name.equals("windows")) {
                ret = os_name.indexOf("windows") > -1;
            } else if (name.equals("os/s")) {
                ret = os_name.indexOf("os/2") > -1;
            } else if (name.equals("netware")) {
                ret = os_name.indexOf("netware") > -1;
            } else if (name.equals("dos")) {
                ret = path_sp.equals(";") && !Os.checkOS("netware");
            } else if (name.equals("macX")) {
                ret = os_name.startsWith("Mac os");
            } else if (name.equals("mac")) {
                ret = os_name.indexOf("mac") > -1;
            } else if (name.equals("tandem")) {
                ret = os_name.indexOf("nonstop_kernel") > -1;
            } else if (name.equals("unix")) {
                ret = path_sp.equals(":") && !Os.checkOS("openvms") && (!Os.checkOS("mac") || os_name.endsWith("x"));
            } else if (name.equals("win9x")) {
                ret = Os.checkOS("windows") && (os_name.indexOf("95") >= 0 || os_name.indexOf("98") >= 0 || os_name.indexOf("me") >= 0 || os_name.indexOf("ce") >= 0);
            } else if (name.equals("z/os")) {
                ret = os_name.indexOf("z/os") > -1 || os_name.indexOf("os/390") > -1;
            } else if (name.equals("os/400")) {
                ret = os_name.indexOf("os/400") > -1;
            } else if (name.equals("openvms")) {
                ret = os_name.indexOf("openvms") > -1;
            }
        }
        return ret;
    }
}

