/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.luxio;

import java.io.File;
import java.io.IOException;
import org.maachang.luxio.AtomicLONG;
import org.maachang.luxio.KeyLock;
import org.maachang.luxio.LuxIo;
import org.maachang.luxio.NativeLuxIO;

public class LuxIoImpl
implements LuxIo {
    private final AtomicLONG fd = new AtomicLONG(-1L);
    private final KeyLock lock = new KeyLock();

    private LuxIoImpl() {
    }

    public LuxIoImpl(String name) throws Exception {
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u6307\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (!NativeLuxIO.useInit()) {
            throw new IOException("Lux IO \u306fWindows\u307e\u305f\u306fLinux\u4ee5\u5916\u3067\u52d5\u4f5c\u3057\u307e\u305b\u3093");
        }
        long fd = NativeLuxIO.open(NativeLuxIO.nativeString(name = new File(name).getCanonicalPath()));
        if (fd == 0L) {
            throw new IOException("\u30d5\u30a1\u30a4\u30eb\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
        }
        this.fd.set(fd);
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        long fd = this.fd.get();
        if (fd != -1L) {
            this.fd.set(-1L);
            NativeLuxIO.close(fd);
        }
    }

    public boolean isUse() {
        return this.fd.get() != -1L;
    }

    public void put(String key, byte[] value) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0 || value == null || value.length <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.lock.lock(key);
        try {
            if (NativeLuxIO.set(this.fd.get(), NativeLuxIO.nativeString(key), value, value.length) <= -1) {
                throw new IOException("\u66f8\u304d\u8fbc\u307f\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
        finally {
            this.lock.unlock(key);
        }
    }

    public byte[] get(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        byte[] ret = null;
        this.lock.lock(key);
        try {
            ret = NativeLuxIO.get(this.fd.get(), NativeLuxIO.nativeString(key));
        }
        finally {
            this.lock.unlock(key);
        }
        return ret;
    }

    public void remove(String key) throws Exception {
        if (!this.isUse()) {
            throw new IOException("\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (key == null || key.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.lock.lock(key);
        try {
            if (NativeLuxIO.remove(this.fd.get(), NativeLuxIO.nativeString(key)) <= -1) {
                throw new IOException("\u524a\u9664\u51e6\u7406\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
            }
        }
        finally {
            this.lock.unlock(key);
        }
    }
}

