package org.maachang.rawio.mapping ;

import org.maachang.rawio.Baseio;

/**
 * MappingI/O.
 *  
 * @version 2008/06/12
 * @author  masahito suzuki
 * @since   Rawio 1.00
 */
public interface Mappingio extends Baseio {
    
    /**
     * データの更新.
     * @exception Exception 例外.
     */
    public void flush() throws Exception ;
    
    /**
     * 指定範囲のMappingを追加.
     * @param start Mapping開始位置を設定します.
     * @param length Mapping設定長を設定します.
     * @return Mapping操作オブジェクトが返されます.
     * @exception Exception 例外.
     */
    public MappingOp addMapping( int start,int length ) throws Exception ;
    
    /**
     * 指定位置がMaapingされているかチェック.
     * @param no ポジションを設定します.
     * @return boolean [true]の場合、Mappingされています.
     * @exception Exception 例外.
     */
    public boolean isMapping( int no ) throws Exception ;
    
    /**
     * 全マッピング長を取得.
     * @return int 全マッピング長が返されます.
     * @exception Exception 例外.
     */
    public int mappingSize() throws Exception ;
    
    /**
     * 元のBaseioを取得.
     * @return Baseio 元のBaseioが返されます.
     */
    public Baseio getBaseio() ;
}
