#define _GNU_SOURCE
#define _XOPEN_SOURCE 600

#define _LARGEFILE64_SOURCE 1
#include <errno.h>

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdlib.h>
#include <stdlib.h>
#include <string.h>
//#include <stdio.h>
//#include <sys/uio.h>

#include "../../include/org_maachang_rawio_NativeRawIO.h"
#include "cpu.h"

// t@CI[vp[~bV.
#define PERMISSION 0666

// ZN^TCY.
#define SECTOR_SIZE 512

// I/O|C^.
typedef struct {
    int handle ;
    char* readBuf ;
    char* writeBuf ;
} HRAW,*LPHRAW ;

// ZN^擾.
int GetSector( const char* path ) {
    return SECTOR_SIZE ;
    //return -1 ;
}

// V[N|Cg擾.
off64_t _GetPosRawIO( int sector,int pos ) {
    return ( off64_t )( ( off64_t )sector * ( off64_t )pos ) ;
}

// rawioI[v.
jlong OpenRawIO( int* result,char* path ) {
    LPHRAW ret ;
    int fp ;
    fp = open64( path,
        ( O_RDWR | O_DIRECT | O_NOATIME | O_CREAT | O_LARGEFILE | O_SYNC ),
        PERMISSION ) ;
    if( fp <= -1 ) {
        *result = 0 ;
        return ( jlong )-1 ;
    }
    posix_fadvise64( fp, 0, 0, POSIX_FADV_RANDOM ) ;
    ret = ( LPHRAW )malloc( sizeof( HRAW ) ) ;
    ret->handle = fp ;
    ret->readBuf = ( char* )valloc( SECTOR_SIZE ) ;
    ret->writeBuf = ( char* )valloc( SECTOR_SIZE ) ;
    *result = 1 ;
    return ( jlong )ret ;
}

// rawioN[Y.
void CloseRawIO( jlong handle ) {
    LPHRAW hraw ;
    hraw = ( LPHRAW )handle ;
    if( hraw->handle > -1 ) {
        close( hraw->handle ) ;
        free( hraw->readBuf ) ;
        free( hraw->writeBuf ) ;
    }
    hraw->readBuf = NULL ;
    hraw->writeBuf = NULL ;
    hraw->handle = -1 ;
}

// wʒũZN^.
int WriteRawIO( jlong handle,int sector,char* data,int pos ) {
    LPHRAW hraw ;
    off64_t off;
    int ret;
    hraw = ( LPHRAW )handle ;
    if( hraw->handle > -1 ) {
        memcpy( hraw->writeBuf,data,sector ) ;
        off = _GetPosRawIO( sector,pos ) ;
        ret = pwrite64( hraw->handle,hraw->writeBuf,sector,off ) ;
        if( ret <= -1 ) {
            return -1 ;
        }
        return ret ;
    }
    return -1 ;
}

// wʒũZN^ǂݍ.
int ReadRawIO( jlong handle,int sector,char* data,int pos ) {
    LPHRAW hraw ;
    off64_t off;
    int ret;
    hraw = ( LPHRAW )handle ;
    if( hraw->handle > -1 ) {
        off = _GetPosRawIO( sector,pos ) ;
        ret = pread64( hraw->handle,hraw->readBuf,sector,off ) ;
        if( ret <= -1 ) {
            return -1 ;
        }
        memcpy( data,hraw->readBuf,sector ) ;
        return ret ;
    }
    return -1 ;
}

// ݂̃t@CTCY擾.
int GetLengthRawIO( jlong* out,jlong handle ) {
    LPHRAW hraw ;
    struct stat64 buf64;
    int ret;
    hraw = ( LPHRAW )handle ;
    if( hraw->handle > -1 ) {
        ret = fstat64( hraw->handle,&buf64 );
        if( ret >= 0 ) {
            *out = buf64.st_size ;
        }
        else {
            *out = 0 ;
            ret = -1 ;
        }
        return ret ;
    }
    return -1 ;
}

// t@CTCYZbg.
int SetLengthRawIO( jlong handle,jlong len ) {
    int ret = 0 ;
    LPHRAW hraw ;
    hraw = ( LPHRAW )handle ;
    if( hraw->handle > -1 ) {
         ret = ftruncate64( hraw->handle,len ) ;
         //if( ret > 0 ) {
         //   posix_fadvise64( hraw->handle, 0, len, POSIX_FADV_RANDOM ) ;
         //}
         return ret ;
    }
    return -1 ;
}

///////////////////////////////////////////////////////////////////////////////
// JNI.
///////////////////////////////////////////////////////////////////////////////

// ZN^TCY擾.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_getSector
  (JNIEnv* env, jclass c, jbyteArray a1) {
    return GetSector( NULL ) ;
}

// nhZN^擾.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_getSectorByHandle
  (JNIEnv* env, jclass c, jlong a1) {
    return GetSector( NULL ) ;
}

// Rawt@CI[v.
JNIEXPORT jlong JNICALL Java_org_maachang_rawio_NativeRawIO_rawOpen
  (JNIEnv* env, jclass c, jbyteArray a1, jbyteArray a2) {
    jbyte* path;
    int result ;
    jlong ret;
    path = (*env)->GetPrimitiveArrayCritical(env, a1, NULL);
    ret = OpenRawIO( &result,( char* )path ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a1, path, JNI_ABORT);
    if( result == 0 ) {
        return ( jlong )-1 ;
    }
    return ret ;
}

// Rawt@CN[Y.
JNIEXPORT void JNICALL Java_org_maachang_rawio_NativeRawIO_rawClose
  (JNIEnv* env, jclass c, jlong a1) {
    CloseRawIO( a1 ) ;
}

// Rawt@C.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_rawWrite
  (JNIEnv* env, jclass c, jlong a1, jint a2, jbyteArray a3) {
    jbyte* dt;
    dt = (*env)->GetPrimitiveArrayCritical(env, a3, NULL);
    jint ret = WriteRawIO( a1,SECTOR_SIZE,dt,a2 ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a3, dt, JNI_ABORT);
    return ret ;
}

// Rawt@Cǂݍ.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_rawRead
  (JNIEnv* env, jclass c, jlong a1, jint a2, jbyteArray a3) {
    jbyte* dt;
    dt = (*env)->GetPrimitiveArrayCritical(env, a3, NULL);
    jint ret = ReadRawIO( a1,SECTOR_SIZE,dt,a2 ) ;
    (*env)->ReleasePrimitiveArrayCritical(env, a3, dt, 0);
    return ret ;
}

// Rawt@C擾.
JNIEXPORT jlong JNICALL Java_org_maachang_rawio_NativeRawIO_getRawLength
  (JNIEnv* env, jclass c, jlong a1) {
    jlong ret;
    ret = 0 ;
    if( GetLengthRawIO( &ret,a1 ) <= -1 ) {
        return ( jlong )-1 ;
    }
    return ret ;
}

// Rawt@CZbg.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_setRawLength
  (JNIEnv* env, jclass c, jlong a1, jlong a2) {
    if( SetLengthRawIO( a1,a2 ) <= -1 ) {
        return -1 ;
    }
    return 0 ;
}

// CPUgp擾.
JNIEXPORT jdouble JNICALL Java_org_maachang_rawio_NativeRawIO_getUseCpu
  (JNIEnv* env, jclass c) {
    return useCpu() ;
}

// vZXID擾.
JNIEXPORT jint JNICALL Java_org_maachang_rawio_NativeRawIO_getProcessId
  (JNIEnv* env, jclass c) {
    return getProcessId() ;
}

