package org.maachang.comet.net.nio ;

import java.nio.ByteBuffer;
import java.util.LinkedList;

/**
 * 書き込み処理を行うデータを管理するキュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
public class WriteDataQueue {
    
    /**
     * キューデータ.
     */
    private final LinkedList<ByteBuffer> queue = new LinkedList<ByteBuffer>() ;
    
    /**
     * NioElement停止フラグ.
     */
    private boolean useConnectFlag = true ;
    
    /**
     * 同期オブジェクト.
     */
    private final Object sync = new Object() ;
    
    /**
     * コンストラクタ.
     */
    protected WriteDataQueue() {
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public void destroy() {
        synchronized( sync ) {
            queue.clear() ;
            useConnectFlag = false ;
        }
    }
    
    /**
     * オブジェクトリセット.
     */
    public void reset() {
        synchronized( sync ) {
            queue.clear() ;
        }
    }
    
    /**
     * 先頭にデータを追加.
     * @param accept
     */
    public void appendHead( ByteBuffer accept ) {
        if( accept != null ) {
            synchronized( sync ) {
                queue.addFirst( accept ) ;
            }
        }
    }
    
    /**
     * 一番最後にデータを追加.
     * @param accept
     */
    public void append( ByteBuffer accept ) {
        if( accept != null ) {
            synchronized( sync ) {
                queue.add( accept ) ;
            }
        }
    }
    
    /**
     * 先頭のデータを削除して取得.
     * @return
     */
    public ByteBuffer getQueue() {
        ByteBuffer ret = null ;
        synchronized( sync ) {
            if( queue.size() > 0 ) {
                ret = queue.removeFirst() ;
            }
        }
        return ret ;
    }
    
    /**
     * サイズを取得.
     * @return
     */
    public int size() {
        int ret = 0 ;
        synchronized( sync ) {
            ret = queue.size() ;
        }
        return ret ;
    }
    
    /**
     * コネクション有効チェック.
     * @return boolean [true]の場合、動作しています.
     */
    public boolean isUse() {
        boolean ret ;
        synchronized( sync ) {
            ret = useConnectFlag ;
        }
        return ret ;
    }
}
