package org.maachang.comet.net.nio ;

import java.util.LinkedList;

/**
 * 受信情報を保持したソケットオブジェクト管理キュー.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
class ReceiveLinkQueue {
    private final LinkedList<NioElement> queue = new LinkedList<NioElement>() ;
    
    public ReceiveLinkQueue() {
    }
    
    public synchronized void destroy() {
        queue.clear() ;
    }
    
    public synchronized void append( NioElement accept ) {
        if( accept != null ) {
            queue.add( accept ) ;
        }
    }
    
    public synchronized NioElement getQueue() {
        if( queue.size() > 0 ) {
            return queue.removeFirst() ;
        }
        return null ;
    }
    
    public synchronized int size() {
        return queue.size() ;
    }
}
