package org.maachang.comet.net.nio ;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;

/**
 * １つのコネクションオブジェクト.
 * 
 * @version 2008/05/28
 * @author  masahito suzuki
 * @since   MaachangComet 1.1B
 */
public interface ConnectionInfo {
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * コネクションオブジェクトを破棄します.
     */
    public void destroy() ;
    
    /**
     * オブジェクトクリア.
     */
    public void clear() ;
    
    /**
     * オブジェクト複製.
     * @return ConnectionInfo 複製されたオブジェクトが返されます.
     * @exception Exception 例外.
     */
    public ConnectionInfo copy() throws Exception ;
    
    /**
     * Nio要素を取得.
     * <BR>
     * @return NioElement Nio要素が返されます.
     */
    public NioElement getElement() ;
    
    /**
     * KeepAliveタイムアウト値を設定.
     * <BR><BR>
     * @param time 対象のKeepAliveタイムアウト値を設定します.
     */
    public void setTimeout( int time ) ;
    
    /**
     * KeepAliveタイムアウト値を取得.
     * <BR><BR>
     * @return long KeepAliveタイムアウト値がミリ秒単位で返されます.
     */
    public long getTimeout() ;
    
    /**
     * KeepAliveカウントを取得.
     * <BR><BR>
     * @return int KeepAliveカウント値が返されます.
     */
    public int getCount() ;
    
    /**
     * 送信用ストリームを取得.
     * <BR>
     * @return OutputStream 送信用ストリームが返されます.
     */
    public OutputStream getOutputStream()
        throws Exception ;
    
    /**
     * 受信用ストリームを取得.
     * <BR>
     * @return InputStream 受信用ストリームが返されます.
     */
    public InputStream getInputStream()
        throws Exception ;
    
    /**
     * 受信用ストリームを取得.
     * <BR>
     * @param timeout 対象のタイムアウト値を設定します.
     * @return InputStream 受信用ストリームが返されます.
     */
    public InputStream getInputStream( long timeout )
        throws Exception ;
    
    /**
     * InetAddressを取得.
     * <br>
     * @return InetAddress InetAddressが返されます.
     */
    public InetAddress getInetAddress() ;
    
    /**
     * ポート番号を取得.
     * <br>
     * @return int ポート番号が返されます.
     */
    public int getPort() ;
    
    /**
     * コネクションクローズを設定.
     * <BR>
     * @param mode [true]の場合、オブジェクト利用後に
     *             コネクションをクローズするか設定します.
     */
    public void setCloseFlag( boolean mode ) ;
    
    /**
     * コネクション再利用.
     */
    public boolean recyclingConnection() ;
    
    /**
     * コネクションクローズを取得.
     * <BR>
     * @return boolean [true]の場合、コネクションクローズを行います.
     */
    public boolean isCloseFlag() ;
    
    /**
     * オブジェクトが有効かチェック.
     * <BR>
     * @return boolean [true]の場合、有効です.
     */
    public boolean isUse() ;
    
    /**
     * コメット実行設定.
     */
    public void cometOn() ;
    
    /**
     * コメット実行フラグ.
     */
    public boolean isComet() ;
}
