package org.maachang.comet.httpd.engine.session ;

import org.maachang.session.client.PSessionManager;

/**
 * 永続化セッション管理[PersistenceSession]を利用した、
 * セッション管理オブジェクト.
 *
 * @version 2008/05/26
 * @author  masahito suzuki
 * @since   MaachangComet 1.19
 */
public class HttpdSessionManager {
    
    /**
     * セッション文字数.
     */
    public static final int SESSION_ID_LENGTH = 48 ;
    
    /**
     * 永続化セッション管理.
     */
    private PSessionManager manager = null ;
    
    /**
     * コンストラクタ.
     */
    private HttpdSessionManager() {
    }
    
    /**
     * コンストラクタ.
     * @param manager 対象のセッション削除時間を設定します.
     */
    public HttpdSessionManager( PSessionManager manager ) {
        this.manager = manager ;
    }
    
    /**
     * 新しいセッションを発行.
     * <BR><BR>
     * 新しいセッションを発行します.
     * <BR>
     * @return HttpdSession 新しいセッション情報が返されます.
     * @exception Exception 例外.
     */
    public HttpdSession getNewSession() throws Exception {
        return new PHttpdSessionImpl( manager.getSession() ) ;
    }
    
    /**
     * セッションIDを指定して、セッションを取得.
     * <BR><BR>
     * セッションIDを指定して、セッションを取得します.
     * <BR>
     * @param id 対象のセッションIDを設定します.
     * @return HttpdSession 対象のセッション情報が返されます.
     * @exception Exception 例外.
     */
    public HttpdSession getSession( String id ) throws Exception {
        return new PHttpdSessionImpl( manager.getSession( id ) ) ;
    }
    
    /**
     * 対象セッションを削除.
     * <BR><BR>
     * 対象のセッションを削除します.
     * <BR>
     * @param id 対象のセッションIDを設定します.
     * @exception Exception 例外.
     */
    public void removeSession( String id ) throws Exception {
        manager.reomveSession( id ) ;
    }
    
    /**
     * セッション削除時間を取得.
     * @return long セッション削除時間が返されます.
     */
    public long getDeleteTime() {
        long ret = -1L ;
        try {
            ret = manager.getDeleteSessionTime() ;
        } catch( Exception e ) {
            ret = System.currentTimeMillis() ;
        }
        return ret ;
    }
    
}
