package org.maachang.comet.httpd.engine.script.scripts;

import org.maachang.comet.MaachangDef;
import org.maachang.comet.httpd.engine.script.ScriptDef;
import org.maachang.comet.httpd.engine.script.js.InitJS;
import org.maachang.util.FileUtil;

/**
 * Controllerスクリプト.
 * 
 * @version 2007/08/29
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class ControllerScript extends AbstractScript {
    
    private ControllerScript() {
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 条件を指定してオブジェクトを生成します.
     * <BR>
     * @param path 対象のパスを設定します.
     * @param currentDirectory カレントディレクトリを設定します.
     * @exception Exception 例外.
     */
    public ControllerScript( String path,String currentDirectory )
        throws Exception {
        super.create( "Controller",MaachangDef.DIRECTORY_APPLICATION,
            path,currentDirectory ) ;
    }
    
    /**
     * スクリプトタイプを取得.
     * <BR><BR>
     * スクリプトタイプを取得します.
     * <BR>
     * @return int スクリプトタイプが返されます.
     */
    public int getScriptType() {
        return ScriptManager.SCRIPT_TYPE_BY_CONTROLLER ;
    }
    
    /**
     * Headerスクリプトを設定.
     */
    protected String addHeaderScript() throws Exception {
        String controllerPath = path.substring( 0,path.length() - "Controller".length() ) ;
        StringBuilder buf = new StringBuilder() ;
        buf.append( InitJS.getInstance().get() ).append( "\n" ).
            append( ScriptDef.SCRIPT_LAST_CONTROLLER ).append( " = \"" ).append( controllerPath ).append( "\" ;\n" ) ;
        return buf.toString() ;
    }
    
    /**
     * Footerスクリプトを設定.
     */
    protected String addFooterScript() throws Exception {
        String file = FileUtil.getFileName( path ) ;
        String dir = path.substring( 0,path.length()-file.length() ) ;
        int p = file.lastIndexOf( ScriptManager.SCRIPT_BY_CONTROLLER ) ;
        if( p == -1 ) {
            return null ;
        }
        file = file.substring( 0,p ) ;
        return new StringBuilder().append( "\n forwardMHTML(\"" ).
            append( dir ).append( file ).append( "\");\n" ).toString() ;
    }
}
