package org.maachang.comet.httpd.engine.script.image;

import org.maachang.dao.DeleteJoinPlugin;
import org.maachang.dbm.MDbm;

/**
 * イメージ操作.
 * 
 * @version 2008/01/27
 * @author masahito suzuki
 * @since MaachangComet 1.07
 */
public interface ImageOp extends DeleteJoinPlugin {
    
    /**
     * 画像タイプ : JPEG.
     */
    public static final int TYPE_JPEG = 1 ;
    
    /**
     * 画像タイプ : GIF.
     */
    public static final int TYPE_GIF = 2 ;
    
    /**
     * 画像タイプ : PNG.
     */
    public static final int TYPE_PNG = 3 ;
    
    /**
     * 画像タイプ : BMP.
     */
    public static final int TYPE_BMP = 4 ;
    
    /**
     * 画像タイプ : Flash.
     */
    public static final int TYPE_FLASH = 5 ;
    
    /**
     * 新しい画像を保存.
     * <BR><BR>
     * 新しい画像を保存します.
     * <BR>
     * @param type 対象のイメージタイプを設定します.<BR>
     *             たとえば、JPEGの場合は、[TYPE_JPEG]を設定します.
     * @param image 対象のイメージバイナリを設定します.
     * @return long 新しく追加されたIDが返されます.
     * @exception Exception 例外.
     */
    public long add( int type,byte[] image ) throws Exception ;
    
    /**
     * 指定画像を置き換える.
     * <BR><BR>
     * 指定画像IDの内容を置き換えます.
     * <BR>
     * @param type 対象のイメージタイプを設定します.<BR>
     *             たとえば、JPEGの場合は、[TYPE_JPEG]を設定します.
     * @param image 対象のイメージバイナリを設定します.
     * @param id 対象のIDを設定します.
     * @exception Exception 例外.
     */
    public void set( int type,byte[] image,long id ) throws Exception ;
    
    /**
     * 指定IDの画像情報を取得.
     * <BR><BR>
     * 指定IDの画像情報を取得します.
     * <BR>
     * @param id 対象のIDを設定します.
     * @return ImageData 対象のバイナリが返されます.
     */
    public ImageData get( long id ) throws Exception ;
    
    /**
     * MDBMオブジェクトを取得.
     * <BR><BR>
     * MDBMオブジェクトを取得します.
     * <BR>
     * @return MDbm MDBMオブジェクトが返されます.
     */
    public MDbm getMDbm() ;
    
    /**
     * 指定IDの情報が存在するかチェック.
     * <BR><BR>
     * 指定IDの情報が存在するかチェックします.
     * <BR>
     * @param id 対象のIDを設定します.
     * @return boolean [true]の場合、存在します.
     */
    public boolean isImageId( long id ) ;
    
    /**
     * データ管理ディレクトリ先を取得.
     * <BR><BR>
     * データ管理ディレクトリ先を取得します.
     * <BR>
     * @return String データ管理ディレクトリ先が返されます.
     */
    public String getDirectory() ;
    
    /**
     * データ出力が可能かチェック.
     * <BR><BR>
     * データ取得が可能かチェックします.
     * <BR>
     * @return boolean [true]の場合、書き込み可能です.
     */
    public boolean isWrite() ;
    
}
