package org.maachang.comet.httpd.engine.script.dao;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.maachang.dao.ExecutionDao;
import org.maachang.dao.ResultLine;
import org.maachang.dao.dbms.MetaColumn;

/**
 * Javascript変換処理付きResultLine.
 * 
 * @version 2007/11/04
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class JsResultLine extends ResultLine {
    /**
     * １行情報を取得.
     * @return Map<String,Object> １行情報が返されます.
     * @exception Exception 例外.
     */
    public Map<String,Object> next() throws Exception {
        if( result == null ) {
            return null ;
        }
        if( result.next() == false ) {
            return null ;
        }
        if( column == null ) {
            column = new MetaColumn(name,result.getMetaData());
        }
        Map<String,Object> ret = new HashMap<String,Object>() ;
        ExecutionDao.convertResultByObject( ret,column,result ) ;
        Iterator it = ret.keySet().iterator() ;
        while( it.hasNext() ) {
            String key = ( String )it.next() ;
            Object value = ret.get( key ) ;
            ret.put( key,DaoUtil.convertResult( name,key,value ) ) ;
        }
        count ++ ;
        return ret ;
    }
}
