package org.maachang.comet.httpd.engine.script.dao;

import java.util.HashMap;

import org.maachang.dao.MaachangDaoException;
import org.maachang.dao.dbms.DbUtil;
import org.maachang.dao.dbms.MetaColumn;
import org.maachang.dao.dbms.Record;


/**
 * Dao管理.
 * 
 * @version 2007/11/04
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class DaoFactory {
    
    /**
     * Dao管理.
     */
    private HashMap<String,Dao> man = null ;
    
    /**
     * コンストラクタ.
     */
    public DaoFactory() {
        man = new HashMap<String,Dao>() ;
    }
    
    /**
     * デストラクタ.
     */
    protected void finalize() throws Exception {
        man = null ;
    }
    
    /**
     * 全てのDao管理情報をクリア.
     * <BR><BR>
     * 全てのDao管理情報をクリアします.
     */
    public synchronized void clear() {
        man = new HashMap<String,Dao>() ;
    }
    
    /**
     * 対象のDaoを取得.
     * <BR><BR>
     * 対象のDaoを取得します.
     * <BR>
     * @param record 対象のレコードオブジェクトを設定します.
     * @param model 対象のモデル名を設定します.
     * @return Dao 対象のDao情報が返されます.
     * @exception MaachangDaoException MaachangDao例外.
     */
    public synchronized Dao getDao( Record record,String model )
        throws MaachangDaoException {
        try {
            if( record == null || model == null || ( model = model.trim() ).length() <= 0 ) {
                throw new MaachangDaoException( "引数は不正です" ) ;
            }
            Dao ret = null ;
            if( ( ret = man.get( model ) ) == null ) {
                ret = new Dao( model ) ;
                man.put( model,ret ) ;
            }
            return ret ;
        } catch( MaachangDaoException md ) {
            throw md ;
        } catch( Exception e ) {
            throw new MaachangDaoException( e ) ;
        }
    }
    
}
