package org.maachang.comet.httpd.engine;

import org.maachang.comet.httpd.HttpdErrorDef;
import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.httpd.HttpdStateException;
import org.maachang.comet.httpd.engine.script.image.ImageData;
import org.maachang.comet.httpd.engine.script.image.ImageManager;
import org.maachang.comet.httpd.engine.script.image.ImageOp;

/**
 * イメージマネージャ読み込み.
 * 
 * @version 2008/01/09
 * @author masahito suzuki
 * @since MaachangComet 1.07
 */
public class ImageManagerReader {
    
    /**
     * 画像管理URLヘッダ.
     */
    public static final String HEAD_IMAGE_MANAGER_URL = "/%00i%00m%00g_" ;
    
    /**
     * 画像データ.
     */
    private ImageData imageData = null ;
    
    /**
     * コンストラクタ.
     */
    private ImageManagerReader() {
        
    }
    
    /**
     * コンストラクタ.
     * <BR><BR>
     * 指定URLを設定します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     * @exception Exception 例外.
     */
    public ImageManagerReader( HttpdRequest request ) throws Exception {
        long id = convertId( request.getUrlPath() ) ;
        ImageOp man = ImageManager.getImageOp( false ) ;
        if( man.isImageId( id ) == false ) {
            throw new HttpdStateException( HttpdErrorDef.HTTP11_403,
                "指定画像情報は存在しません" ) ;
        }
        this.imageData = man.get( id ) ;
        man = null ;
    }
    
    private static final long convertId( String url ) throws Exception {
        long id = -1L ;
        try {
            id = Long.parseLong( url.substring( HEAD_IMAGE_MANAGER_URL.length() ) ) ;
        } catch( Exception e ) {
            throw new HttpdStateException( HttpdErrorDef.HTTP11_403,
                "不正なURLです" ) ;
        }
        return id ;
    }
    
    /**
     * オブジェクト破棄.
     * <BR><BR>
     * オブジェクトを破棄します.
     */
    public void destroy() {
        if( imageData != null ) {
            imageData.destroy() ;
        }
        imageData = null ;
    }
    
    /**
     * 更新時間を取得.
     * <BR><BR>
     * 対象イメージデータの更新時間を取得します.
     * <BR>
     * @return long 更新時間が返されます.
     */
    public long getLastTime() {
        return imageData.getLastTime() ;
    }
    
    /**
     * 対象画像情報をレスポンスに反映.
     * <BR><BR>
     * 対象画像情報をレスポンスに反映します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     * @return HttpdResponse レスポンス情報が返されます.
     * @exception Exception 例外.
     */
    public HttpdResponse getResponse( HttpdRequest request )
        throws Exception {
        if( imageData == null ) {
            return null ;
        }
        HttpdResponse ret = HttpdResponseInstance.createResponse( request,request.getUrlPath(),
            request.getKeepAliveTimeout(),request.getKeepAliveCount() ) ;
        ret.setCookieSession( request ) ;
        ret.getHeader().addHeader( HttpdDef.VALUE_LAST_UPDATE,
            HttpdTimestamp.getTimestamp( imageData.getLastTime() ) ) ;
        //ret.getHeader().addHeader( HttpdDef.VALUE_CONTENT_LENGTH,
        //    String.valueOf( imageData.getLength() ) ) ;
        ret.getHeader().addHeader( HttpdDef.VALUE_CONTENT_TYPE,
            String.valueOf( imageData.getMime() ) ) ;
        ret.setHttpClose( false ) ;
        ret.setGzip( false ) ;
        ret.getOutput().write( imageData.getImage() ) ;
        this.destroy() ;
        return ret ;
    }
}
