package org.maachang.comet.httpd.engine;

import org.maachang.comet.httpd.HttpdRequest;
import org.maachang.comet.httpd.HttpdResponse;
import org.maachang.comet.net.HttpdBaseResponse;

/**
 * HTTPDレスポンス生成オブジェクト.
 * 
 * @version 2007/09/03
 * @author masahito suzuki
 * @since MaachangComet 1.00
 */
public class HttpdResponseInstance {
    
    /**
     * ステータスを設定してレスポンス情報を生成.
     * <BR><BR>
     * ステータスを設定してレスポンス情報を生成します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     * @param url 対象のリクエストURLを設定します.
     * @param timeout 対象のタイムアウト値を設定します.
     * @param count 対象のカウント値を設定します.
     * @return HttpResponse レスポンス情報が返されます.
     * @exception Exception 例外.
     */
    public static final HttpdResponse createResponse( HttpdRequest request,String url,long timeout,int count )
        throws Exception {
        return new HttpdBaseResponse( request,url,timeout,count ) ;
    }
    
    /**
     * ステータスを設定してレスポンス情報を生成.
     * <BR><BR>
     * ステータスを設定してレスポンス情報を生成します.
     * <BR>
     * @param request 対象のリクエストを設定します.
     * @param url 対象のリクエストURLを設定します.
     * @param state 対象のHTTPコードを設定します.
     * @param timeout 対象のタイムアウト値を設定します.
     * @param count 対象のカウント値を設定します.
     * @return HttpResponse レスポンス情報が返されます.
     * @exception Exception 例外.
     */
    public static final HttpdResponse createResponse( HttpdRequest request,String url,int state,long timeout,int count )
        throws Exception {
        return new HttpdBaseResponse( request,url,state,timeout,count ) ;
    }
}