package org.maachang.comet.httpd ;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * HTTPD-パラメータ群.
 *
 * @version 2007/08/20
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public interface HttpdParams {
    
    /**
     * パラメータオブジェクトをマージ.
     * <BR><BR>
     * 指定オブジェクトをマージします.
     * <BR>
     * @param param 対象のパラメータオブジェクトを設定します.
     */
    public void add( HttpdParams param ) ;
    
    /**
     * パラメータ追加.
     * <BR><BR>
     * パラメータを追加します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void addParam( String key,Object value ) ;
    
    /**
     * パラメータ設定.
     * <BR><BR>
     * パラメータを設定します.<BR>
     * この条件で設定した場合、以前に登録したkeyに
     * 対する内容はクリアされます.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param value 対象の要素を設定します.
     */
    public void setParam( String key,Object value ) ;
    
    /**
     * パラメータを削除.
     * <BR><BR>
     * 対象のパラメータを削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     */
    public void removeParam( String key ) ;
    
    /**
     * パラメータを削除.
     * <BR><BR>
     * 対象のパラメータを削除します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     */
    public void removeParam( String key,int no ) ;
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * 対象のパラメータを取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object 対象の要素情報が返されます.
     */
    public String getParam( String key ) ;
    
    /**
     * パラメータを取得.
     * <BR><BR>
     * 対象のパラメータを取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     * @return Object 対象の要素情報が返されます.
     */
    public String getParam( String key,int no ) ;
    
    /**
     * パラメータをバイナリオブジェクトとして取得.
     * <BR><BR>
     * 対象のパラメータをバイナリオブジェクトとして取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return HttpdBinary 対象の要素情報が返されます.
     */
    public HttpdBinary getParamByBinary( String key ) ;
    
    /**
     * パラメータをバイナリオブジェクトとして取得.
     * <BR><BR>
     * 対象のパラメータをバイナリオブジェクトとして取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param no 対象の項番を設定します.
     * @return HttpdBinary 対象の要素情報が返されます.
     */
    public HttpdBinary getParamByBinary( String key,int no ) ;
    
    /**
     * パラメータタイプを取得.
     * <BR><BR>
     * パラメータタイプを取得します.
     * <BR>
     * @param key 対象のパラメータキー名を設定します.
     * @return boolean 対象のパラメータタイプが返されます.<BR>
     *                 [true]の場合は、バイナリタイプです.<BR>
     *                 [false]の場合は、文字タイプです.
     */
    public boolean getParamType( String key ) ;
    
    /**
     * パラメータタイプを取得.
     * <BR><BR>
     * パラメータタイプを取得します.
     * <BR>
     * @param key 対象のパラメータキー名を設定します.
     * @param no 対象の項番を設定します.
     * @return boolean 対象のパラメータタイプが返されます.<BR>
     *                 [true]の場合は、バイナリタイプです.<BR>
     *                 [false]の場合は、文字タイプです.
     */
    public boolean getParamType( String key,int no ) ;
    
    /**
     * パラメータ数を取得.
     * <BR><BR>
     * 対象のパラメータ数を取得します.
     * <BR>
     * @return int パラメータ数が返されます.
     */
    public int size() ;
    
    /**
     * パラメータ数を取得.
     * <BR><BR>
     * 対象のパラメータ数を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return int パラメータ数が返されます.
     */
    public int size( String key ) ;
    
    /**
     * キー名群を取得.
     * <BR><BR>
     * 対象のキー名群を取得します.
     * <BR>
     * @return String[] キー名群が返されます.
     */
    public String[] getKeys() ;
    
    /**
     * Iteratorを取得.
     * @return Iterator Iteratorが返されます.
     */
    public Iterator iterator() ;
    
    /**
     * 指定キーが存在するかチェック.
     * <BR><BR>
     * 指定キーが存在するかチェックします.
     * <BR>
     * @param key 対象のキー名を取得します.
     * @return boolean [true]の場合、存在します.
     */
    public boolean isKey( String key ) ;
    
    /**
     * 管理パラメータを取得.
     * <BR><BR>
     * このオブジェクトが管理しているパラメータを取得します.
     * <BR>
     * @return Map<String,Object> 管理パラメータが返されます.
     */
    public Map<String,Object> getPrivateMap() ;
}

