package org.maachang.comet.conf ;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

import org.maachang.comet.MaachangDef;
import org.maachang.conf.Config;
import org.maachang.conf.ReadIni;
import org.maachang.util.FileUtil;

/**
 * 基本コンフィグ.
 *
 * @version 2007/09/03
 * @author  masahito suzuki
 * @since   MaachangComet 1.00
 */
public class BaseConfig {
    
    /**
     * ターゲットセクション名.
     */
    private static final String BASE_SECTION = "base-config" ;
    
    /**
     * キャラクタセット.
     */
    private static final String CHARSET = "UTF8" ;
    
    /**
     * 読み込みファイル名.
     */
    private static final String READ_FILE = MaachangDef.DIRECTORY_CONFIG+"base.conf" ;
    
    /**
     * 予約定義ファイル名 : ユーザ管理ファイル.
     */
    private static final String USERS_MANAGER = "users" ;
    
    /**
     * 予約定義ファイル名 : DBユーザ管理ファイル.
     */
    private static final String DB_USERS_MANAGER = "dbusers" ;
    
    /**
     * 予約定義ファイル名 : Mime管理ファイル.
     */
    private static final String MIME_MANAGER = "mime" ;
    
    /**
     * 予約定義ファイル名 : Mail管理ファイル.
     */
    private static final String MAIL_MANAGER = "mail" ;
    
    /**
     * 予約定義ファイル名 : Pacakge定義ファイル.
     */
    private static final String PACKAGES_MANAGER = "packages" ;
    
    /**
     * 予約定義ファイル名 : その他コンフィグファイル.
     */
    private static final String CONFIG_MANAGER = "config" ;
    
    /**
     * 読み込み対象データ.
     */
    private Config iniParams = null ;
    
    /**
     * 対象ファイル.
     */
    private String fileName = null ;
    
    /**
     * オープン.
     * <BR><BR>
     * オープンします.
     * <BR>
     * @exception Exception 例外.
     */
    public synchronized void open() throws Exception {
        this.open( READ_FILE ) ;
    }
    
    /**
     * オープン.
     * <BR><BR>
     * オープンします.
     * <BR>
     * @param name 対象のファイル名を設定します.
     * @exception Exception 例外.
     */
    public synchronized void open( String name ) throws Exception {
        this.fileName = FileUtil.getFullPath( name ) ;
        try {
            this.reload() ;
        } catch( Exception e ) {
            this.close() ;
            throw e ;
        } finally {
        }
    }
    
    /**
     * クローズ.
     * <BR><BR>
     * クローズ処理.
     */
    public synchronized void close() {
        iniParams = null ;
        fileName = null ;
    }
    
    /**
     * ユーザ管理ファイル名を取得.
     * <BR><BR>
     * 定義されているユーザ管理ファイル名を取得します.
     * <BR>
     * @return String ユーザ管理ファイル名が返されます.
     */
    public String getUsers() {
        return iniParams.get( BASE_SECTION,USERS_MANAGER,0) ;
    }
    
    /**
     * DB上でユーザ管理を行うファイル名を取得.
     * <BR><BR>
     * 定義されているDB上でユーザ管理を行うファイル名を取得します.
     * <BR>
     * @return String DB上でユーザ管理を行うファイル名が返されます.
     */
    public String getDbUsers() {
        return iniParams.get( BASE_SECTION,DB_USERS_MANAGER,0 ) ;
    }
    
    /**
     * Mime管理ファイル名を取得.
     * <BR><BR>
     * 定義されているMime管理ファイル名を取得します.
     * <BR>
     * @return String Mime管理ファイル名が返されます.
     */
    public String getMimes() {
        return iniParams.get( BASE_SECTION,MIME_MANAGER,0 ) ;
    }
    
    /**
     * Mail管理ファイル名を取得.
     * <BR><BR>
     * 定義されているMail管理ファイル名を取得します.
     * <BR>
     * @return String Mail管理ファイル名が返されます.
     */
    public String getMail() {
        return iniParams.get( BASE_SECTION,MAIL_MANAGER,0 ) ;
    }
    
    /**
     * Packages定義ファイル名を取得.
     * <BR><BR>
     * 定義されているPackages定義ファイル名を取得します.
     * <BR>
     * @return String Packages定義ファイル名が返されます.
     */
    public String getPackages() {
        return iniParams.get( BASE_SECTION,PACKAGES_MANAGER,0 ) ;
    }
    
    /**
     * コンフィグファイルを取得.
     * <BR><BR>
     * コンフィグに設定するファイル名が返されます.
     * <BR>
     * @param no 対象の項番を設定します.
     * @return String コンフィグに定義するファイル名が返されます.
     */
    public String getConfig( int no ) {
        return iniParams.get( BASE_SECTION,CONFIG_MANAGER,no ) ;
    }
    
    /**
     * コンフィグファイル数を取得.
     * <BR><BR>
     * コンフィグファイル数が返されます.
     * <BR>
     * @return int コンフィグファイル数が返されます.
     */
    public int size() {
        return iniParams.size( BASE_SECTION,CONFIG_MANAGER ) ;
    }
    
    /**
     * 再読み込み.
     */
    private final void reload()
        throws Exception {
        BufferedReader buf = null ;
        if( FileUtil.isFileExists( fileName ) == true ) {
            try {
                buf = new BufferedReader(
                    new InputStreamReader(
                        new FileInputStream( fileName ),CHARSET ) ) ;
                Config iniParams = new Config() ;
                ReadIni.analisys( iniParams,buf ) ;
                buf.close() ;
                buf = null ;
                // 読み込みデータを設定.
                this.iniParams = iniParams ;
            } catch( Exception e ) {
                throw e ;
            } finally {
                if( buf != null ) {
                    try {
                        buf.close() ;
                    } catch( Exception e ) {
                    }
                }
            }
        }
    }
}
