package org.maachang.comet;

import org.maachang.comet.httpd.engine.HttpdEngine;
import org.maachang.comet.net.NetService;
import org.maachang.dao.dbms.RecordFactory;
import org.maachang.manager.GlobalManager;
import org.maachang.rawio.Cpu;

/**
 * MaachangCometシステム情報.
 * 
 * @version 2007/08/26
 * @author masahito suzuki
 * @since MaachangComet 1.27
 */
public class MSystem {
    
    /** ネットサービスを取得. */
    private static final NetService netService() {
        return ( ( HttpdEngine )GlobalManager.getInstance().get( ServiceDef.MANAGER_BY_HTTPD ) ).getNetService() ;
    }
    
    /** レコードファクトリを取得. */
    private static final RecordFactory recordFactory() {
        return ( RecordFactory )GlobalManager.getInstance().get( ServiceDef.MANAGER_BY_DBMS_POOL ) ;
    }
    
    /**
     * ネットワーク有効プーリングスレッド数を取得.
     * @return int 有効プーリングスレッド数が返されます.
     */
    public static int getNetUsePooling() {
        return netService().getNioService().getUsePooling() ;
    }
    
    /**
     * ネットワークActiveプーリングスレッド数を取得.
     * @return int Activeプーリングスレッド数が返されます.
     */
    public static int getNetActivePooling() {
        return netService().getNioService().getActivePooling() ;
    }
    
    /**
     * DBコネクション最大プーリング数を取得. <BR>
     * <BR>
     * 最大プーリング数を取得します. <BR>
     * 
     * @return int 管理されている最大プーリング数が返されます.
     */
    public static int getDbMax() {
        return recordFactory().getConnectionManager().getMax() ;
    }

    /**
     * DBコネクション現在アクティブであるプーリングコネクション数を取得. <BR>
     * <BR>
     * 現在アクティブであるプーリングコネクション数を取得します. <BR>
     * 
     * @return int 現在アクティブなプーリングコネクション数が返されます.
     */
    public static int getDbActives() {
        return recordFactory().getConnectionManager().getActives() ;
    }
    
    /**
     * DBコネクション現在アイドルであるプーリングコネクション数を取得. <BR>
     * <BR>
     * 現在アイドルであるプーリングコネクション数を取得します. <BR>
     * 
     * @return int 現在アイドルなプーリングコネクション数が返されます.
     */
    public static int getDbIdle() {
        return recordFactory().getConnectionManager().getIdle() ;
    }
    
    /**
     * CPU使用率を取得.
     * @return double CPU使用率が返されます.
     */
    public static final double useCpu() {
        return MSystem.getInstance()._useCpu() ;
    }
    
    /**
     * プロセスIDを取得.
     * @return int プロセスIDが返されます.
     */
    public static final int getProcessId() {
        return MSystem.getInstance()._getProcessId() ;
    }
    
    // 内部用.
    private static final long NEXT_TIME = 3000L ;
    private double useCpu = 0.0f ;
    private int processId = -1 ;
    
    private static final MSystem SNGL = new MSystem() ;
    protected static final MSystem getInstance() {
        return SNGL ;
    }
    private boolean processIdFlag = false ;
    private synchronized int _getProcessId() {
        if( processIdFlag ) {
            return processId ;
        }
        processId = Cpu.getProcessId() ;
        processIdFlag = true ;
        return processId ;
    }
    
    private long next = -1L ;
    private synchronized double _useCpu() {
        long t = System.currentTimeMillis() ;
        if( t >= next + NEXT_TIME ) {
            useCpu = Cpu.useCpu() ;
            next = t ;
        }
        return useCpu ;
    }
}
