package org.maachang.util.net;

/**
 * ネットワークアダプタ要素.
 * 
 * @version 2008/10/28
 * @author masahito suzuki
 * @since MaachangBase 1.08
 */
public class NetAdapterElement {

    /**
     * IPアドレス.
     */
    private String addr = null;

    /**
     * サブネットマスク.
     */
    private String netMask = null;

    /**
     * Macアドレス.
     */
    private String macAddr = null;

    /**
     * コンストラクタ.
     */
    public NetAdapterElement() {

    }

    /**
     * コンストラクタ.
     * 
     * @param addr
     *            IPアドレスを設定します.
     * @param netMask
     *            サブネットマスクを設定します.
     * @param macAddr
     *            マックアドレスを設定します.
     */
    public NetAdapterElement(String addr, String netMask, String macAddr) {
        this.addr = addr;
        this.netMask = netMask;
        this.macAddr = macAddr;
    }

    /**
     * addr を取得. <BR>
     * <BR>
     * 
     * @return addr が返されます.
     */
    public String getAddr() {
        return addr;
    }

    /**
     * addr を設定. <BR>
     * <BR>
     * 
     * @param addr
     *            addr を設定します.
     */
    public void setAddr(String addr) {
        this.addr = addr;
    }

    /**
     * macAddr を取得. <BR>
     * <BR>
     * 
     * @return macAddr が返されます.
     */
    public String getMacAddr() {
        return macAddr;
    }

    /**
     * macAddr を設定. <BR>
     * <BR>
     * 
     * @param macAddr
     *            macAddr を設定します.
     */
    public void setMacAddr(String macAddr) {
        this.macAddr = macAddr;
    }

    /**
     * netMask を取得. <BR>
     * <BR>
     * 
     * @return netMask が返されます.
     */
    public String getNetMask() {
        return netMask;
    }

    /**
     * netMask を設定. <BR>
     * <BR>
     * 
     * @param netMask
     *            netMask を設定します.
     */
    public void setNetMask(String netMask) {
        this.netMask = netMask;
    }
    
    /**
     * オブジェクトを文字列変換.
     * @return String 文字列で返されます.
     */
    public String toString() {
        return new StringBuilder().
            append( " IPADDR:" ).append( addr ).
            append( " NETMASK:" ).append( netMask ).
            append( " MACADDR:" ).append( ( ( macAddr == null ) ? "none" : macAddr ) ).
            toString() ;
    }
}
