package org.maachang.util.net;

import java.util.Iterator;

/**
 * ネットワークアダプタ情報. <BR>
 * <BR>
 * ネットワークアダプタ情報をサポートします.
 * 
 * @version 2008/10/28
 * @author masahito suzuki
 * @since MaachangBase 1.08
 */
public interface NetAdapter {

    /**
     * 情報クリア. <BR>
     * <BR>
     * 情報をクリアします.
     */
    public void clear();

    /**
     * ネットワーク情報取得処理.
     * 
     * @exception Exception
     *                例外.
     */
    public void load() throws Exception;

    /**
     * 指定媒体名を取得.
     * 
     * @param name
     *            対象の媒体名(LANの場合[eth0]など.)を設定します.
     * @return NetAdapterElement 要素が返されます.
     */
    public NetAdapterElement get(String name);

    /**
     * 媒体名群の取得.
     * 
     * @return Iterator Iteratorが返されます.
     */
    public Iterator iterator();

    /**
     * 媒体数を取得.
     * 
     * @return int 媒体数が返されます.
     */
    public int size();

}
