package org.maachang.util;

import java.util.LinkedList;

/**
 * バッファキュー.
 * 
 * @version 2008/10/24
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class SimpleQueue<T> {
    
    /** キュー管理 */
    private LinkedList<T> queue = null ;
    
    /**
     * コンストラクタ.
     */
    public SimpleQueue() {
        queue = new LinkedList<T>() ;
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    /**
     * オブジェクト破棄.
     */
    public synchronized void destroy() {
        if( queue != null ) {
            queue.clear() ;
        }
    }
    
    /**
     * データ追加.
     * @param value 追加対象のデータを設定します.
     */
    public synchronized void add( T value ) {
        if( queue == null || value == null ) {
            return ;
        }
        queue.add( value ) ;
    }
    
    /**
     * 先頭にデータ追加.
     * @param value 対象の情報を設定します.
     */
    public synchronized void addFirst( T value ) {
        if( queue == null || value == null ) {
            return ;
        }
        queue.addFirst( value ) ;
    }
    
    /**
     * データ取得.
     * @return T 格納されているデータが返されます.
     */
    public synchronized T get() {
        if( queue == null || queue.size() <= 0 ) {
            return null ;
        }
        return queue.removeFirst() ;
    }
    
    /**
     * 格納数取得.
     * @return int 格納数が返されます.
     */
    public synchronized int size() {
        return queue.size() ;
    }
}
