package org.maachang.util;

/**
 * Key,Value情報.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class KeyValue {
    
    private String key = null ;
    private String value = null ;
    
    /**
     * キー情報を設定.
     * <BR><BR>
     * キー情報を設定します.
     * <BR>
     * @param key 対象のキー情報を設定します.
     */
    public void setKey( String key ) {
        this.key = key ;
    }
    
    /**
     * キー情報を取得.
     * <BR><BR>
     * キー情報を取得します.
     * <BR>
     * @return String キー情報が返されます.
     */
    public String getKey() {
        return this.key ;
    }
    
    /**
     * Value情報を設定.
     * <BR><BR>
     * Value情報を設定します.
     * <BR>
     * @param value 対象のValue情報を設定します.
     */
    public void setValue( String value ) {
        this.value = value ;
    }
    
    /**
     * Value情報をBooleanで設定.
     * <BR><BR>
     * Value情報をBooleanで設定します.
     * <BR>
     * @param value 対象の情報を設定します.
     */
    public void setValue( Boolean value ) {
        if( value != null ) {
            this.value = value.toString() ;
        }
        else {
            this.value = null ;
        }
    }
    
    /**
     * Value情報をIntegerで設定.
     * <BR><BR>
     * Value情報をIntegerで設定します.
     * <BR>
     * @param value 対象の情報を設定します.
     */
    public void setValue( Integer value ) {
        if( value != null ) {
            this.value = value.toString() ;
        }
        else {
            this.value = null ;
        }
    }
    
    /**
     * Value情報をLongで設定.
     * <BR><BR>
     * Value情報をLongで設定します.
     * <BR>
     * @param value 対象の情報を設定します.
     */
    public void setValue( Long value ) {
        if( value != null ) {
            this.value = value.toString() ;
        }
        else {
            this.value = null ;
        }
    }
    
    /**
     * Value情報をDoubleで設定.
     * <BR><BR>
     * Value情報をDoubleで設定します.
     * <BR>
     * @param value 対象の情報を設定します.
     */
    public void setValue( Double value ) {
        if( value != null ) {
            this.value = value.toString() ;
        }
        else {
            this.value = null ;
        }
    }
    
    /**
     * Value情報を取得.
     * <BR><BR>
     * Value情報を取得します.
     * <BR>
     * @return String value情報が返されます.
     */
    public String getValue() {
        return this.value ;
    }
    
    /**
     * Value情報をBooleanで取得.
     * <BR><BR>
     * Value情報をBooleanで取得します.
     * <BR>
     * @return Boolean value情報が返されます.
     */
    public Boolean getValueByBoolean() {
        return StringByParams.getBooleanObject( this.value ) ;
    }
    
    /**
     * Value情報をIntegerで取得.
     * <BR><BR>
     * Value情報をIntegerで取得します.
     * <BR>
     * @return Integer value情報が返されます.
     */
    public Integer getValueByInteger() {
        return StringByParams.getIntObject( this.value ) ;
    }
    
    /**
     * Value情報をLongで取得.
     * <BR><BR>
     * Value情報をLongで取得します.
     * <BR>
     * @return Long value情報が返されます.
     */
    public Long getValueByLong() {
        return StringByParams.getLongObject( this.value ) ;
    }
    
    /**
     * Value情報をDoubleで取得.
     * <BR><BR>
     * Value情報をDoubleで取得します.
     * <BR>
     * @return Double value情報が返されます.
     */
    public Double getValueByDouble() {
        return StringByParams.getDoubleObject( this.value ) ;
    }
    
}
