package org.maachang.util;

/**
 * 指定キャラクタセットに似た内容でマスク.
 * 
 * @version 2008/04/16
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class CharsetMask {
    /**
     * ISO 8859-1 ラテンアルファベット No1.
     */
    public static final String ISO_8859_1 = "ISO8859_1" ;
    
    /**
     * 8ビット Unicode Transformation Format.
     */
    public static final String UTF8 = "UTF8" ;
    
    /**
     * 16ビット Unicode Transformation Format、
     * 必須の初期バイト順マークによって指定されたバイト順.
     */
    public static final String UTF16 = "UTF16" ;
    
    /**
     * 32ビット Unicode Transformation Format、
     * 必須の初期バイト順マークによって指定されたバイト順.
     */
    public static final String UTF32 = "UTF32" ;
    
    /**
     * American Standard Code for Information Interchange.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String ASCII = "ASCII" ;
    
    /**
     * ISO 2022 JP.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String JIS = "ISO2022JP" ;
    
    /**
     * JIS X 0201、0208、0212、EUC エンコーディング、日本語.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String EUC = "EUC_JP" ;
    
    /**
     * Shift-JIS、日本語.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String SJIS = "Shift_JIS" ;
    
    /**
     * Windows 日本語-NS932.
     * <BR><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String MS932 = "MS932" ;
    
    /**
     * Windows 日本語-Win31J.
     * <RB><BR>
     * ※OSによってはサポートされていない場合があります.
     */
    public static final String WIN31J = "Windows-31J" ;
    
    /**
     * 対応変換表.
     */
    private static final String[] CONVERT_CODE = {
        ISO_8859_1,ISO_8859_1,
        "ISO_8859_1",ISO_8859_1,
        "ISO-8859-1",ISO_8859_1,
        UTF8,UTF8,
        "UTF-8",UTF8,
        UTF16,UTF16,
        "UTF-16",UTF16,
        UTF32,UTF32,
        "UTF-32",UTF32,
        ASCII,ASCII,
        JIS,JIS,
        "ISO_2022_JP",JIS,
        "ISO-2022-JP",JIS,
        EUC,EUC,
        "EUC-JP",EUC,
        SJIS,SJIS,
        "SHIFT-JIS",SJIS,
        "SJIS",SJIS,
        MS932,MS932,
        "MS-932",MS932,
        "MS_932",MS932,
        "WINDOWS-31J",WIN31J,
        "WINDOWS_31J",WIN31J,
        "WINDOWS31J",WIN31J } ;
    
    /**
     * 指定キャラクタセットに似たキャラクタセットを取得.
     * @param charset 対象のキャラクタセットを設定します.
     * @return String 対象のキャラクタセットが返されます.
     */
    public static final String getCharset( String charset ) {
        if( charset == null || charset.length() <= 0 ) {
            return null ;
        }
        charset = charset.toUpperCase() ;
        int len = CONVERT_CODE.length ;
        for( int i = 0 ; i < len ; i += 2 ) {
            if( charset.startsWith( CONVERT_CODE[ i ].toUpperCase() ) ) {
                return CONVERT_CODE[ i+1 ] ;
            }
        }
        return null ;
    }
    
}
