package org.maachang.shutdown ;

/**
 * サーバプロセスに対してシャットダウンを通知する.
 * 
 * @version 2008/05/26
 * @author masahito suzuki
 * @since MaachangBase 1.02
 */
public class ExecutionShutdown {
    
    /**
     * １回のシャットダウン待ち.
     */
    private static final int TIMEOUT = 5000 ;
    
    /**
     * シャットダウンリトライ数.
     */
    private static final int RETRY = 12 ;
    
    /**
     * コンストラクタ.
     */
    private ExecutionShutdown() {
        
    }
    
    /**
     * シャットダウン通知.
     * @param port 対象のポート番号を設定します.
     * @exception Exception 例外.
     */
    public static final boolean execution( int port )
        throws Exception {
        boolean ret = false ;
        try {
            for( int i = 0 ; i < RETRY ; i ++ ) {
                if( new SendShutdown().send( port,TIMEOUT ) == true ) {
                    ret = true ;
                    break ;
                }
            }
        } catch( Exception e ) {
            throw e ;
        }
        return ret ;
    }
    
}

