package org.maachang.manager ;

import java.util.HashMap;

/**
 * ThreadLocal管理.
 * 
 * @version 2007/10/18
 * @author masahito suzuki
 * @since MaachangBase 1.00
 */
public class LocalManager {
    
    /**
     * ローカルスレッド.
     */
    private ThreadLocal<HashMap<String, Object>> threadLocal =
        new ThreadLocal<HashMap<String, Object>>() ;
    
    /**
     * コンストラクタ.
     */
    private LocalManager() {
    }
    
    /**
     * シングルトン.
     */
    private static final LocalManager SNGL = new LocalManager();
    
    /**
     * シングルトンを取得.
     * <BR><BR>
     * シングルトンオブジェクトを取得します.
     * <BR>
     * @return LocalManager スレッドローカル情報が返されます.
     */
    public static final LocalManager getInstance() {
        return SNGL;
    }
    
    /**
     * ローカルスレッド情報に追加.
     * <BR><BR>
     * ローカルスレッド情報に追加します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @param val 対象の要素を設定します.
     */
    public void put(String key, Object val) {
        HashMap<String, Object> o = threadLocal.get();
        if (o == null) {
            o = new HashMap<String, Object>();
            threadLocal.set(o);
        }
        o.put(key, val);
    }
    
    /**
     * ローカルスレッド情報を取得.
     * <BR><BR>
     * ローカルスレッド情報を取得します.
     * <BR>
     * @param key 対象のキー名を設定します.
     * @return Object 対象の要素が返されます.
     */
    public Object get(String key) {
        HashMap<String, Object> o = threadLocal.get() ;
        if (o == null) {
            return null;
        }
        return o.get(key);
    }
}
