package org.maachang.connector ;

import java.net.InetAddress;

/**
 * クライアントコネクションファクトリ.
 * 
 * @version 2008/05/27
 * @author masahito suzuki
 * @since MaachangBase 1.02
 */
public class ClientConnectorFactory {
    
    /**
     * 単一クライアントコネクションを取得.
     * @param headerBinary 通信ヘッダバイナリを設定します.
     * @param addr 接続先アドレスを設定します.
     * @param port 接続先ポート番号を設定します.
     * @param timeout 受信タイムアウト値を設定します.
     * @return ClientConnector クライアントコネクションが返されます.
     * @exception Exception 例外.
     */
    public static final ClientConnector getSingleConnector( byte[] headerBinary,InetAddress addr,int port,int timeout )
        throws Exception {
        return new SingleClientConnector( headerBinary,addr,port,timeout ) ;
    }
    
    /**
     * プーリングクライアントコネクションを取得.
     * @param headerBinary 通信ヘッダバイナリを設定します.
     * @param addr 接続先アドレスを設定します.
     * @param port 接続先ポート番号を設定します.
     * @param timeout 受信タイムアウト値を設定します.
     * @param pooling プーリング数を設定します.
     * @return ClientConnector クライアントコネクションが返されます.
     * @exception Exception 例外.
     */
    public static final ClientConnector getPoolingConnector( byte[] headerBinary,InetAddress addr,int port,int timeout,int pooling )
        throws Exception {
        return new PoolingClientConnector( headerBinary,addr,port,timeout,pooling ) ;
    }
}
