package org.maachang.dbm.engine ;

/**
 * １つのセクタヘッダ.
 * 
 * @version 2008/06/05
 * @author masahito suzuki
 * @since MaachangDBM 1.12
 */
class M2SectorHeader {
    
    /**
     * セクタタイプ.
     */
    protected int sectorType = -1 ;
    
    /**
     * 次の書き込み項番.
     */
    protected int nextNo = -1 ;
    
    /**
     * 次の書き込み項番(ファイルNo).
     */
    protected int nextFileNo = -1 ;
    
    /**
     * １セクタのデータ長.
     */
    protected int length = -1 ;
    
    /**
     * コンストラクタ.
     */
    public M2SectorHeader() {
        this.sectorType = MDbmDefine.SECTOR_TYPE_NORMAL ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        sectorType = -1 ;
        nextNo = -1 ;
        nextFileNo = -1 ;
        length = -1 ;
    }
    
    /**
     * length を取得.
     * <BR><BR>
     * @return length が返されます.
     */
    public int getLength() {
        return length;
    }
    
    /**
     * length を設定.
     * <BR><BR>
     * @param length length を設定します.
     */
    public void setLength(int length) {
        this.length = length;
    }
    
    /**
     * nextFileNo を取得.
     * <BR><BR>
     * @return nextFileNo が返されます.
     */
    public int getNextFileNo() {
        return nextFileNo;
    }
    
    /**
     * nextFileNo を設定.
     * <BR><BR>
     * @param nextFileNo nextFileNo を設定します.
     */
    public void setNextFileNo(int nextFileNo) {
        this.nextFileNo = nextFileNo;
    }
    
    /**
     * nextNo を取得.
     * <BR><BR>
     * @return nextNo が返されます.
     */
    public int getNextNo() {
        return nextNo;
    }
    
    /**
     * nextNo を設定.
     * <BR><BR>
     * @param nextNo nextNo を設定します.
     */
    public void setNextNo(int nextNo) {
        this.nextNo = nextNo;
    }
    
    /**
     * セクタタイプを取得.
     * <BR><BR>
     * @return int sectorType が返されます.
     */
    public int getSectorType() {
        return sectorType ;
    }
    
    /**
     * セクタタイプを設定.
     * <BR><BR>
     * @param sectorType sectorType を設定します.
     */
    public void setSectorType( int sectorType ) {
        this.sectorType = sectorType ;
    }
    
    /**
     * オブジェクトコピー.
     */
    public void copyObject( M2SectorHeader object ) {
        object.sectorType = this.sectorType ;
        object.nextNo = this.nextNo ;
        object.nextFileNo = this.nextFileNo ;
        object.length = this.length ;
    }
    
    public String toString() {
        return new StringBuilder().
            append( " sectorType:" ).append( sectorType ).
            append( " nextNo:" ).append( nextNo ).
            append( " nextFileNo:" ).append( nextFileNo ).
            append( " length:" ).append( length ).toString() ;
    }
}
