// mailスクリプト.
//

// Mailオブジェクト.
Mail = function() {} ;

// テンプレートを使ったメール送信.
Mail.sendByTemplateFile = function( templateFileName,params,from,to,attached,setting ) {
    var template = MaachangTemplate.readTemplateFile( templateFileName ) ;
    return Mail.sendByTemplateData( template,params,from,to,attached,setting ) ;
}

// テンプレートデータを引数で指定して、メール送信.
Mail.sendByTemplateData = function( template,params,from,to,attached,setting ) {
    if( isNull( template ) || useString( template ) == false ) {
        return false ;
    }
    template = MaachangTemplate.executionTemplate( template,params ) ;
    if( isNull( template ) || useString( template ) == false ) {
        return false ;
    }
    var title = Mail.getTemplateByMailTitle( template ) ;
    var body = Mail.getTemplateByBody( template ) ;
    template = null ;
    return Mail.send( from,to,title,body,attached,setting ) ;
}

// １行目をタイトルとして、メールテンプレート内容から抜き出す.
Mail.getTemplateByMailTitle = function( template ) {
    if( useString( template ) == false ) {
        return null ;
    }
    var p = template.indexOf( "\n" ) ;
    if( p <= -1 ) {
        return "" ;
    }
    var ret = template.substring( 0,p ) ;
    ret = changeString( ret,"\r","" ) ;
    return changeString( ret,"\n","" ) ;
} ;

// ２行目以降を、本文として、メールテンプレート内容から抜き出す.
Mail.getTemplateByBody = function( template ) {
    if( useString( template ) == false ) {
        return null ;
    }
    var p = template.indexOf( "\n" ) ;
    if( p <= -1 ) {
        return template ;
    }
    var ret = template.substring( p ) ;
    if( startsWith( ret,"\r" ) ) {
        ret = ret.substring( 1 ) ;
    }
    if( startsWith( ret,"\n" ) ) {
        ret = ret.substring( 1 ) ;
    }
    return ret;
}

// メール送信.
Mail.send = function( from,to,subject,body,attached,setting ) {
    if( isNull( from ) || isNull( to ) ) {
        return false ;
    }
    var sendMail = org.maachang.comet.httpd.engine.script.service.mail.CreateMailBean.getSendMail() ;
    if( isNull( sendMail ) ) {
        return false ;
    }
    sendMail.setFrom( from ) ;
    if( valueof( to ) == "array" ) {
        var lst = new java.util.ArrayList() ;
        var len = to.length ;
        for( var i = 0 ; i < len ; i ++ ) {
            lst.add( to[i] ) ;
        }
        sendMail.setTo( lst ) ;
    }
    else {
        var lst = new java.util.ArrayList() ;
        lst.add( ""+to ) ;
        sendMail.setTo( lst ) ;
    }
    if( useString( subject ) == false ) {
        subject = "no title" ;
    }
    sendMail.setSubject( subject ) ;
    if( useString( body ) == false ) {
        body = "" ;
    }
    sendMail.setBody( body ) ;
    if( isNull( attached ) ) {
        var t = valueof( attached ) ;
        if( t == "map" ) {
            if( isNull( attached["name"] ) == false && isNull( attached["body"] ) == false ) {
                var at = new org.maachang.comet.httpd.engine.script.service.mail.ResultAttached() ;
                at.setFileName( attached["name"] ) ;
                at.setAttached( attached["body"] ) ;
                var lst = new ArrayList() ;
                lst.add( at ) ;
                sendMail.setAttached( lst ) ;
            }
        }
        else if( t == "array" ) {
            var len = attached.length ;
            if( len > 0 ) {
                var lst = new ArrayList() ;
                for( var i = 0 ; i < len ; i ++ ) {
                    var one = attached[i] ;
                    if( isNull( one ) == false && valueof( one ) == "map" &&
                        isNull( one["name"] ) == false && isNull( one["body"] ) == false ) {
                        var at = new org.maachang.comet.httpd.engine.script.service.mail.ResultAttached() ;
                        at.setFileName( one["name"] ) ;
                        at.setAttached( one["body"] ) ;
                        lst.add( at ) ;
                    }
                }
                if( lst.size() > 0 ) {
                    sendMail.setAttached( lst ) ;
                }
            }
        }
    }
    Mail.settingMailParams( true,sendMail,setting ) ;
    return org.maachang.comet.httpd.engine.script.service.mail.SendMailService.sendMailTo( sendMail ) ;
}

// メール受信.
Mail.receive = function( mode,removeFlag,setting ) {
    var receiveMail = org.maachang.comet.httpd.engine.script.service.mail.CreateMailBean.getReceiveMail() ;
    if( isNull( receiveMail ) ) {
        return null ;
    }
    receiveMail.setDelete( ( ( removeFlag == true ) ? true : false ) ) ;
    Mail.settingMailParams( false,receiveMail,setting ) ;
    mode = ( mode == true ) ? true : false ;
    var result = org.maachang.comet.httpd.engine.script.service.mail.ReceiveMailService.receiveMailTo( mode,receiveMail ) ;
    if( isNull( result ) ) {
        return null ;
    }
    return Mail.convertResultMail( result ) ;
}

// パラメータセッティング.
Mail.settingMailParams = function( mode,out,setting ) {
    if( isNull( out ) || isNull( setting ) || valueof( setting ) != "map" ) {
        return null ;
    }
    if( isNull( setting['host'] ) == false ) {
        out.setHost( setting['host'] ) ;
    }
    if( isNull( setting['port'] ) == false ) {
        out.setPort( setting['port'] ) ;
    }
    if( isNull( setting['timeout'] ) == false ) {
        out.setTimeout( setting['timeout'] ) ;
    }
    if( isNull( setting['ssl'] ) == false ) {
        out.setSsl( setting['ssl'] ) ;
    }
    
    if( mode == true ) {
        if( isNull( setting['auth'] ) == false ) {
            out.setAuth( setting['auth'] ) ;
        }
        if( out.isAuth() == true ) {
            if( isNull( setting['user'] ) == false ) {
                out.setUser( setting['user'] ) ;
            }
            if( isNull( setting['passwd'] ) == false ) {
                out.setPasswd( setting['passwd'] ) ;
            }
        }
        else {
            out.setUser( null ) ;
            out.setPasswd( null ) ;
        }
    }
    else {
        if( isNull( setting['user'] ) == false ) {
            out.setUser( setting['user'] ) ;
        }
        if( isNull( setting['passwd'] ) == false ) {
            out.setPasswd( setting['passwd'] ) ;
        }
    }
    return out ;
}

// 受信メール結果を変換.
Mail.convertResultMail = function( result ) {
    if( isNull( result ) ||
        ( result instanceof java.util.List ) == false ||
        result.size() <= 0 ) {
        return [] ;
    }
    var ret = [] ;
    var len = result.size() ;
    for( var i = 0 ; i < len ; i ++ ) {
        var one = result.get( i ) ;
        var oneMail = {} ;
        if( one.getTo() != null && one.getTo().size() > 0 ) {
            oneMail['to'] = Mail.convertMailByArray( one.getTo() ) ;
        }
        else {
            oneMail['to'] = "" ;
        }
        if( one.getFrom() != null && one.getFrom().size() > 0 ) {
            oneMail['from'] = Mail.convertMailByArray( one.getFrom() ) ;
        }
        else {
            oneMail['from'] = "" ;
        }
        if( one.getSubject() != null ) {
            oneMail['subject'] = one.getSubject() ;
        }
        else {
            oneMail['subject'] = "" ;
        }
        if( one.getBody() != null ) {
            oneMail['body'] = one.getBody() ;
        }
        else {
            oneMail['body'] = "" ;
        }
        if( one.getAttached() != null && one.getAttached().size() > 0 ) {
            var atList = one.getAttached() ;
            var lenJ = atList.size() ;
            var atRes = [] ;
            for( var j = 0 ; j < lenJ ; j ++ ) {
                var data = atList.get( j ) ;
                var atBin = {} ;
                atBin['name'] = data.getFileName() ;
                atBin['body'] = data.getAttached() ;
                atRes[j] = atBin ;
            }
            oneMail['attached'] = atRes ;
        }
        ret[i] = oneMail ;
    }
    return ret ;
}

// １つの内容を配列変換.
Mail.convertMailByArray = function( list ) {
    var len = list.size() ;
    var ret = [] ;
    for( var i = 0 ; i < len ; i ++ ) {
        ret[i] = list.get( i ) ;
    }
    return ret ;
}
