// Image管理.
//

// イメージオブジェクト.
Image = function() {} ;

// Imageタイプ:JPEG.
Image.TYPE_JPEG = 1 ;

// Imageタイプ:GIF.
Image.TYPE_GIF = 2 ;

// Imageタイプ:PNG.
Image.TYPE_PNG = 3 ;

// Imageタイプ:BMP.
Image.TYPE_BMP = 4 ;

// Imageタイプ:Flash.
Image.TYPE_FLASH = 5 ;

// 指定名の拡張子から、Imageタイプを取得.
Image.getType = function( name ) {
    if( useString( name ) == false || name.indexOf( "." ) == -1 ) {
        return -1 ;
    }
    name = trim( name ) ;
    var n = toLowerCase( name ) ;
    if( endsWith( n, ".jpg" ) || endsWith( n, ".jpeg" ) ||
        endsWith( n, ".jpe" ) || endsWith( n, ".jfif" ) ||
        endsWith( n, ".jfi" ) ) {
        return Image.TYPE_JPEG ;
    }
    if( endsWith( n, ".gif" ) ) {
        return Image.TYPE_GIF ;
    }
    if( endsWith( n, ".png" ) ) {
        return Image.TYPE_PNG ;
    }
    if( endsWith( n, ".bmp" ) || endsWith( n, ".rle" ) ||
        endsWith( n, ".dib" ) ) {
        return Image.TYPE_BMP ;
    }
    if( endsWith( n, ".swf" ) ) {
        return Image.TYPE_FLASH ;
    }
    return -1 ;
} ;

// Imageファイルを管理条件に追加.
Image.addImage = function( name,image ) {
    if( isNull( name ) || isNull( image ) ) {
        return -1 ;
    }
    var type = Image.getType( name ) ;
    if( type == -1 ) {
        return -1 ;
    }
    return Image.add( type,image ) ;
}; 

// Imageを管理条件に追加.
Image.add = function( type,image ) {
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        return -1 ;
    }
    if( isNull( script_model().getImageOp() ) ) {
        return -1 ;
    }
    return script_model().getImageOp().add( type,image ) ;
} ;

// Imageファイルを指定IDにセット.
Image.setImage = function( id,name,image ) {
    if( isNumeric( id ) == false || isNull( name ) || isNull( image ) || id <= 0 ) {
        return -1 ;
    }
    var type = Image.getType( name ) ;
    return Image.set( id,type,image ) ;
}

// 指定IDのImageを、対象Imageにセット.
Image.set = function( id,type,image ) {
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        return -1 ;
    }
    if( isNull( script_model().getImageOp() ) ) {
        return -1 ;
    }
    script_model().getImageOp().set( type,image,id ) ;
    return 0 ;
} ;

// 対象IDのImageを削除.
Image.remove = function( id ) {
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        return -1 ;
    }
    if( isNull( script_model().getImageOp() ) ) {
        return -1 ;
    }
    script_model().getImageOp().remove( id ) ;
    return 0 ;
} ;

// 指定IDのImageを取得.
Image.get = function( id ) {
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        return null ;
    }
    if( isNull( script_model().getImageOp() ) ) {
        return -1 ;
    }
    return script_model().getImageOp().get( id ) ;
} ;

// Image保存パスを取得.
Image.path = function() {
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        return null ;
    }
    if( isNull( script_model().getImageOp() ) ) {
        return -1 ;
    }
    return script_model().getImageOp().getDirectory() ;
} ;

// 指定ImageIDが存在するかチェック.
Image.isImage = function( id ) {
    create_base_model() ;
    if( script_model().isCreate() == false ) {
        return false ;
    }
    return script_model().getImageOp().isImageId( id ) ;
} ;

// 指定画像に対するフォーマットを取得.
Image.getFormat = function( data ) {
    if( isNull( data ) ) {
        return null ;
    }
    var bin = null ;
    var t = valueof( data ) ;
    if( t == "string" || t == "number" ) {
        var file = _$script$query.get( "" + data ) ;
        if( isNull( file ) == false && file instanceof org.maachang.comet.httpd.HttpdBinary ) {
            bin = paramBinary( data ) ;
        }
        else {
            return null ;
        }
    }
    else if( t == "binary" ) {
        bin = data ;
    }
    else {
        return null ;
    }
    var ret = org.maachang.comet.httpd.engine.script.image.ImageManager.getImageCodec( bin ) ;
    if( isNull( ret ) ) {
        return null ;
    }
    return ""+ret ;
}

// 指定画像に対する解像度を取得.
Image.getSize = function( data ) {
    if( isNull( data ) ) {
        return null ;
    }
    var bin = null ;
    var t = valueof( data ) ;
    if( t == "string" || t == "number" ) {
        var file = _$script$query.get( "" + data ) ;
        if( isNull( file ) == false && file instanceof org.maachang.comet.httpd.HttpdBinary ) {
            bin = paramBinary( data ) ;
        }
        else {
            return null ;
        }
    }
    else if( t == "binary" ) {
        bin = data ;
    }
    else {
        return null ;
    }
    var res = org.maachang.comet.httpd.engine.script.image.ImageManager.getImageWidthHeight( bin ) ;
    if( isNull( res ) ) {
        return null ;
    }
    return [
        org.maachang.comet.httpd.engine.script.js.JsDef.getArray( res,0 ),
        org.maachang.comet.httpd.engine.script.js.JsDef.getArray( res,1 )
    ] ;
}
