/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.thread;

public abstract class LoopThread
extends Thread {
    private volatile boolean stopFlag = true;
    protected int threadId = -1;

    protected abstract void clear();

    protected abstract boolean execution() throws Exception;

    protected void toException(Throwable e) {
    }

    public synchronized void startThread() throws Exception {
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public int getThreadId() {
        return this.threadId;
    }

    public void stopThread() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    protected synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                if (this.execution()) continue;
                Thread.sleep(30L);
            }
            catch (InterruptedException ite) {
                this.toException(ite);
                endFlag = true;
            }
            catch (NullPointerException ne) {
                this.toException(ne);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (OutOfMemoryError mem) {
                this.toException(mem);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (Exception e) {
                this.toException(e);
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite2) {
                    endFlag = true;
                }
            }
            catch (ThreadDeath td) {
                this.toException(td);
                endFlag = true;
                threadDeach = td;
            }
        }
        LoopThread loopThread = this;
        synchronized (loopThread) {
            this.clear();
        }
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

