/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.util.net;

import java.util.List;
import org.maachang.util.StringUtil;
import org.maachang.util.net.AbstractNetAdapter;

class NetAdapterByWinNT
extends AbstractNetAdapter {
    private static final String IPCONFIG_COMMAND = "ipconfig /all";
    private static final String ADAPTER_NAME = "ethernet adapter";
    private static final String DIV_CODE = ":";
    private static final String ETC_NAME = "description";
    private static final String IP_ADDR_1 = "ip";
    private static final String IP_ADDR_2 = "address";
    private static final String SUB_NET_1 = "subnet";
    private static final String SUB_NET_2 = "mask";
    private static final String MAC_ADDR_1 = "physical";
    private static final String MAC_ADDR_2 = "address";
    private static final String MAC_ADDR_SRC = "-";
    private static final String MAC_ADDR_DEST = ":";

    public NetAdapterByWinNT() {
        this.init();
    }

    public void load() throws Exception {
        List<String> cmdOut = null;
        String name = null;
        String value = null;
        try {
            try {
                this.clear();
                cmdOut = AbstractNetAdapter.runExec(IPCONFIG_COMMAND);
                int len = cmdOut.size();
                int i = 0;
                int localCheck = 0;
                while (i < len) {
                    String bcmd = cmdOut.get(i);
                    String cmd = bcmd.toLowerCase();
                    if (cmd.indexOf(ADAPTER_NAME) != -1 && cmd.indexOf(":") == cmd.length() - 1) {
                        int p = cmd.indexOf(ADAPTER_NAME);
                        name = StringUtil.trim(bcmd.substring(p + ADAPTER_NAME.length(), cmd.length() - 1));
                    } else if (cmd.indexOf(ETC_NAME) == -1 || cmd.indexOf(":") == -1) {
                        if (cmd.indexOf(IP_ADDR_1) != -1 && cmd.indexOf("address") != -1 && cmd.indexOf(":") != -1) {
                            value = StringUtil.trim(bcmd.substring(bcmd.indexOf(":") + 1));
                            if (value.equals("127.0.0.1")) {
                                ++localCheck;
                            }
                            super.setIpAddress(name, value);
                        } else if (cmd.indexOf(SUB_NET_1) != -1 && cmd.indexOf(SUB_NET_2) != -1 && cmd.indexOf(":") != -1) {
                            value = StringUtil.trim(bcmd.substring(bcmd.indexOf(":") + 1));
                            super.setSubnetMask(name, value);
                        } else if (cmd.indexOf(MAC_ADDR_1) != -1 && cmd.indexOf("address") != -1 && cmd.indexOf(":") != -1) {
                            value = StringUtil.trim(bcmd.substring(bcmd.indexOf(":") + 1));
                            value = StringUtil.changeString(value, MAC_ADDR_SRC, ":").toUpperCase();
                            super.setMacAddress(name, value);
                        }
                    }
                    ++i;
                }
                if (localCheck == 0) {
                    super.setIpAddress("lo", "127.0.0.1");
                    super.setSubnetMask("lo", "255.0.0.0");
                }
            }
            catch (Exception e) {
                this.clear();
                throw e;
            }
        }
        finally {
            cmdOut = null;
            name = null;
            value = null;
        }
    }
}

